/* $Id: ImageToolBar.java 350 2011-09-11 15:16:44Z ohura $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.logical.Sheet;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.ResourceBasketsFrame;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBarComponent.IMAGETOOLBARCOMPONENT_TYPE;

@SuppressWarnings("serial")
public class ImageToolBar extends JToolBar implements ActionListener{
	
	private Select select;
	private Eraser eraser;

	private static ModeList modelist;
	public static String[] modelistarray = { "<none>", "Rectangle", "Marker", "Polygon", "MemoPad", "Bookmark", "Eraser"};

	public static int modeNone = 0;
	public static int modeRectangle = 1;
	public static int modeMarker = 2;
	public static int modePolygon = 3;
	public static int modeMemoPad = 4;
	public static int modeBookmark = 5;
	public static int modeEraser = 6;

	public  Basket basket;
	
	private ZoomIn zoomIn;
	private ZoomOut zoomOut;
	private FullSize fullSize;
	private FitWidth fitWidth;
	private FitHeight fitHeight;

	//	private JButton hideRegion;
	private static ShowRegion showRegion;
	public static String[] showregionarray = { "All Regions", "Protected Regions", "No Region" };
	public static int showAll = 0;
	public static int showProtected = 1;
	public static int showNo = 2;
	
//	private JButton changeSheet;
	
	private AbstractGSWindow parent;
	
	public ImageToolBar(AbstractGSWindow parent){
		this.parent = parent;
		
		this.select = new Select(new ImageIcon(GSConstants.ICON_PATH+"select.gif"));
		this.select.addActionListener(this);
		this.select.setToolTipText("Select");
		this.add(this.select);
		
		this.eraser = new Eraser(new ImageIcon(GSConstants.ICON_PATH+"delete.gif"));
		this.eraser.addActionListener(this);
		this.eraser.setToolTipText("Eraser");
		this.add(this.eraser);

		this.basket = new Basket(new ImageIcon(GSConstants.ICON_PATH+"basket.png"));
		this.basket.addActionListener(this);
		this.basket.setToolTipText("Open Resource Basket Window");
		this.add(basket);

		this.modelist = new ModeList(modelistarray);
		this.modelist.addActionListener(this);
		this.modelist.setToolTipText("Select Drawing Mode");
		this.add(modelist);

		
		this.zoomIn = new ZoomIn(new ImageIcon(GSConstants.ICON_PATH+"zoom_in.gif"));
		this.zoomIn.addActionListener(this);
		this.zoomIn.setToolTipText("Zoom in");
		this.zoomIn.setEnabled(false);
		this.add(this.zoomIn);
		
		this.zoomOut = new ZoomOut(new ImageIcon(GSConstants.ICON_PATH+"zoom_out.gif"));
		this.zoomOut.addActionListener(this);
		this.zoomOut.setToolTipText("Zoom out");
		this.zoomOut.setEnabled(false);
		this.add(this.zoomOut);
		
		this.fullSize = new FullSize(new ImageIcon(GSConstants.ICON_PATH + "100percent.png"));
		this.fullSize.addActionListener(this);
		this.fullSize.setToolTipText("Full Size");
		this.fullSize.setEnabled(false);
		this.add(this.fullSize);

		this.fitWidth = new FitWidth(new ImageIcon(GSConstants.ICON_PATH + "fitwidth.png"));
		this.fitWidth.addActionListener(this);
		this.fitWidth.setToolTipText("Fit Width");
		this.fitWidth.setEnabled(false);
		this.add(this.fitWidth);

		this.fitHeight = new FitHeight(new ImageIcon(GSConstants.ICON_PATH + "fitheight.png"));
		this.fitHeight.addActionListener(this);
		this.fitHeight.setToolTipText("Fit Height");
		this.fitHeight.setEnabled(false);
		this.add(this.fitHeight);

		/*
		 * 2007/9/11
		 */
//		this.hideRegion = new JButton("hideRegion");
//		this.hideRegion.addActionListener(this);
//		this.add(this.hideRegion);
		
		showRegion = new ShowRegion(showregionarray);
		showRegion.addActionListener(this);
		showRegion.setToolTipText("Select the type of Regions to show");
		this.add(showRegion);
//		
//		this.changeSheet = new JButton("Sheet");
//		this.changeSheet.addActionListener(this);
//		this.add(this.changeSheet);
	}

	public void actionPerformed(ActionEvent e) {
		
		if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.SELECT)){
			DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
			setModeListItem(modelistarray[modeNone]);
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.MODE_LIST)){
			String mode = (String) ((JComboBox) e.getSource()).getSelectedItem();
			if(mode == modelistarray[modeRectangle]) {
				DefaultState.getInstance().setMode(RectangleMode.getInstance());
				parent.setMode(RectangleMode.getInstance());
			} else if(mode == modelistarray[modeMarker]) {
				DefaultState.getInstance().setMode(MarkerMode.getInstance());
				parent.setMode(MarkerMode.getInstance());
			} else if(mode == modelistarray[modePolygon]) {
				DefaultState.getInstance().setMode(PolygonMode.getInstance());
				parent.setMode(PolygonMode.getInstance());
			} else if(mode == modelistarray[modeMemoPad]) {
				DefaultState.getInstance().setMode(MemoPadMode.getInstance());
				parent.setMode(MemoPadMode.getInstance());
			} else if(mode == modelistarray[modeBookmark]) {
				DefaultState.getInstance().setMode(BookmarkMode.getInstance());
				parent.setMode(BookmarkMode.getInstance());
			} else if(mode == modelistarray[modeNone]) {
				DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
				parent.setMode(DefaultDrawingMode.getInstance());
			} else if(mode == modelistarray[modeEraser]) {
				DefaultState.getInstance().setMode(EraserMode.getInstance());
				parent.setMode(EraserMode.getInstance());
			}
		} else if (((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.BASKET)) {
			ResourceBasketsFrame.getInstance().showResourceBasketFrame();
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.ZOOM_IN)){
			parent.getSpreadCanvas().zoomIn();
			if(parent instanceof WorkspaceWindow){
				((WorkspaceWindow)parent).getHistoryToolBar().zoomInHistoryCanvasScale();
			}
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.ZOOM_OUT)){
			parent.getSpreadCanvas().zoomOut();
			if(parent instanceof WorkspaceWindow){
				((WorkspaceWindow)parent).getHistoryToolBar().zoomOutHistoryCanvasScale();
			}
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.FULL_SIZE)){
			parent.getSpreadCanvas().fullSize();
			if(parent instanceof WorkspaceWindow){
				((WorkspaceWindow)parent).getHistoryToolBar().fullSizeHistoryCanvasScale();
			}
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.FIT_WIDTH)){
			parent.getSpreadCanvas().fitWidth();
			if(parent instanceof WorkspaceWindow){
				((WorkspaceWindow)parent).getHistoryToolBar().fitWidthHistoryCanvasScale();
			}
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.FIT_HEIGHT)){
			parent.getSpreadCanvas().fitHeight();
			if(parent instanceof WorkspaceWindow){
				((WorkspaceWindow)parent).getHistoryToolBar().fitHeightHistoryCanvasScale();
			}
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.ERASER)){
			DefaultState.getInstance().setMode(EraserMode.getInstance());
			parent.setMode(EraserMode.getInstance());
			ImageToolBar.setModeListItem(ImageToolBar.modelistarray[ImageToolBar.modeEraser]);			
			parent.repaint();
		}else if(((ImageToolBarComponent)e.getSource()).getImageToolBarComponentType()
				.equals(IMAGETOOLBARCOMPONENT_TYPE.SHOW_REGION)){
			String showRegionMode = (String) ((JComboBox) e.getSource()).getSelectedItem();
			if(showRegionMode == showregionarray[showAll]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_ALL_REGIONS);
			} else if(showRegionMode == showregionarray[showProtected]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
			} else if(showRegionMode == showregionarray[showNo]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_NO_REGIONS);
			}
			parent.repaint();
		}
	}

	public void enableIcons() {
		this.zoomIn.setEnabled(true);
		this.zoomOut.setEnabled(true);
		this.fullSize.setEnabled(true);
		this.fitWidth.setEnabled(true);
		this.fitHeight.setEnabled(true);
	}

	public static void setModeListItem(String string) {
		modelist.setSelectedItem(string);
	}
	
	public static void setShowRegionItem(String string) {
		showRegion.setSelectedItem(string);
	}
	
	private class Select extends JButton implements ImageToolBarComponent {

		Select(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.SELECT;
		}		
	}
	
	private class Eraser extends JButton implements ImageToolBarComponent {

		Eraser(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ERASER;
		}
	}

	private class Basket extends JButton implements ImageToolBarComponent {
		
		Basket(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.BASKET;
		}
	}

	private class ModeList extends JComboBox implements ImageToolBarComponent {

		ModeList(String[] modelistarray) {
			super(modelistarray);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.MODE_LIST;
		}
	}
	

	private class ShowRegion extends JComboBox implements ImageToolBarComponent {

		ShowRegion(String[] showregionarray) {
			super(showregionarray);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.SHOW_REGION;
		}
	}

	private class ZoomIn extends JButton implements ImageToolBarComponent {

		ZoomIn(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_IN;
		}
	}

	private class ZoomOut extends JButton implements ImageToolBarComponent {

		ZoomOut(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.ZOOM_OUT;
		}
	}

	private class FullSize extends JButton implements ImageToolBarComponent {

		FullSize(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.FULL_SIZE;
		}
	}

	private class FitWidth extends JButton implements ImageToolBarComponent {

		FitWidth(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.FIT_WIDTH;
		}
	}

	private class FitHeight extends JButton implements ImageToolBarComponent {

		FitHeight(ImageIcon imageIcon) {
			super(imageIcon);
		}

		@Override
		public IMAGETOOLBARCOMPONENT_TYPE getImageToolBarComponentType() {
			return IMAGETOOLBARCOMPONENT_TYPE.FIT_HEIGHT;
		}
	}

}
