package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;


public abstract class ListSelectionFrame<E> extends ButtonFrame implements ListSelectionListener{
	protected JList list;
	protected E selectedItem;

	public ListSelectionFrame(Frame parent, String title, List<E> elements) {
		super(parent, title);
		this.makeList(elements);
		
		JPanel panel = (JPanel) this.getContentPane();
		this.setSize(new Dimension(300,300));
		this.setMaximumSize(new Dimension(300,1000));
		list.addListSelectionListener(this);
		list.setVisibleRowCount(20);
		JScrollPane sPane = new JScrollPane(list);
	    panel.add(sPane,BorderLayout.NORTH);

	}

	public abstract void makeList(List<E> elements);

	public void setSelectedItem(E selectedItem) {
		this.selectedItem = selectedItem;
	}

	public E getSelectedItem() {
		return selectedItem;
	}

}
