package smart_gs.network;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JList;
import javax.swing.ScrollPaneLayout;

import jp.ac.nii.hcp.shared.model.HCPProjectContent;

import smart_gs.swingui.WorkspaceWindow;

public class ShowResultDialog extends JDialog {
	private JScrollPane sPane;
	private JList<String> results;
	private JButton ok;
	private String action;
	
	public ShowResultDialog(String action, Exception e) {
		super(ProjectExplorer.getInstance());
		this.action = action;
		this.setModal(true);
		this.results = new JList<String>();
		DefaultListModel<String> model = new DefaultListModel<String>();
		model.addElement("Not succeeded.");
		model.addElement("Exception: " + e.getMessage());
		this.results.setModel(model);
		this.sPane = new JScrollPane(this.results);
		this.ok = new JButton("OK");
		ok.addActionListener(new OKActionListener(this));
		this.build();
		this.setTitle(this.action + " Result");
		this.setSize(500,300);				
	}

	public ShowResultDialog(String action, List<HCPProjectContent> reserved) {
		super(ProjectExplorer.getInstance());
		this.action = action;
		this.setModal(true);
		this.results = new JList<String>();
		DefaultListModel<String> model = new DefaultListModel<String>();
		model.addElement(action + " finished.");
		for (int i = 0; i < reserved.size(); i++) {
			model.addElement("Conflict: " + reserved.get(i).id);
		}
		this.results.setModel(model);
		this.sPane = new JScrollPane(this.results);
		this.ok = new JButton("OK");
		ok.addActionListener(new OKActionListener(this));
		this.build();
		this.setTitle(this.action + " Result");
		this.setSize(500,300);		
	}

	private void build() {
		Container pane = this.getContentPane();
		pane.removeAll();
		this.setTitle("MemoPad");
		this.sPane.setLayout(new ScrollPaneLayout());
		this.getContentPane().add(this.sPane);
		this.getContentPane().add(this.ok);
		
		GroupLayout layout = new GroupLayout(pane);
		pane.setLayout(layout);
		layout.setAutoCreateGaps(true);
		layout.setAutoCreateContainerGaps(true);
		
		layout.setHorizontalGroup(layout.createSequentialGroup()
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.sPane)
				.addComponent(this.ok)
			)
		);
	
	
		layout.setVerticalGroup(layout.createSequentialGroup()
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.sPane))
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.ok)
			)
		);
	}

	
	class OKActionListener implements ActionListener {

		private ShowResultDialog frame;
		
		public OKActionListener(ShowResultDialog frame) {
			this.frame = frame;
		}
		@Override
		public void actionPerformed(ActionEvent arg0) {
			frame.dispose();
		}		
	}
}
