//This class is no longer in use.
package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import jp.ac.nii.hcp.client.core.HCPController;
import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.ProjectDifference;

import smart_gs.network.ProjectActionListener.ProjectAction;
import smart_gs.swingui.ButtonFrame;

class SelectProjectFrame extends ButtonFrame implements ListSelectionListener, ActionListener {
	private ProjectHandler handler;
	private JList<String> list;
	private List<HCPProject> projects;

	public SelectProjectFrame(Frame parent, List<HCPProject> projects, 
			ProjectHandler handler) {
		super(parent, handler.getAction() + ": Select Project");
		this.projects = projects;
		this.handler = handler;
		this.list = new JList<String>();
//		ProjectAction action = this.handler.getAction();
//		try {
//			this.makeList(projects, action);
//		} catch (HCPClientException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
		JPanel panel = (JPanel) this.getContentPane();
//		this.setSize(new Dimension(350,300));
		this.setMaximumSize(new Dimension(350,1000));
		list.addListSelectionListener(this);
		list.setVisibleRowCount(20);
		JScrollPane sPane = new JScrollPane(list);
	    panel.add(sPane,BorderLayout.NORTH);
//		if (action == ProjectAction.CHECKOUT || action == ProjectAction.EXPORT) {
//			JTextField textField = new JTextField();
//			textField.setText(this.handler.getHeadRevision()+"");
//			panel.add(textField, BorderLayout.SOUTH);
//		}
	}
	
	private void makeList(List<HCPProject> projects, ProjectAction action) throws HCPClientException {
		HCPController controller = this.handler.getController();
		DefaultListModel<String> model = new DefaultListModel<String>();
		if (action == ProjectAction.CHECKOUT || action == ProjectAction.EXPORT) {
			for (int i = 0; i < projects.size(); i++) {
				model.addElement(projects.get(i).name);
			}
		} else {
			for (int i = 0; i < projects.size(); i++) {
				String name = projects.get(i).name;
				ProjectDifference diff = controller.status(name);
				int revision = diff.revision;
				this.handler.setHeadRevision(diff.revision);
				this.handler.setRevision(diff.revision);
				model.addElement(name + " (head revision: " + revision + ")");
			}
		}
		this.list.setModel(model);		
	}

	@Override
	public void ok() {
//		this.handler.setProject(this.getSelectedProject());
//		try {
//			this.handler.perform();
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (UnauthorizedException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (HCPClientException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
		this.dispose();
	}

	private HCPProject getSelectedProject() {
		int index = this.list.getSelectedIndex();
		return this.projects.get(index);
	}

	@Override
	public void cancel() {
		this.dispose();
	}

	@Override
	public void valueChanged(ListSelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
}