package smart_gs.network;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

import smart_gs.logical.Preference;
import smart_gs.network.ProjectActionListener.ProjectAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class RepositoryMenu extends JMenu {

	public RepositoryMenu(String title, AbstractGSWindow parent){
		super(title);
		
		JMenu project = new JMenu("Project");
		this.add(project);
		
		JMenuItem explorer = new JMenuItem("Project Explorer");
		project.add(explorer);
		explorer.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				ProjectExplorer.getInstance().setVisible(true);
			}
		});
				
		JMenuItem commit = new JMenuItem("Commit Current Project");
		project.add(commit);
		commit.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				//TODO
			}
		});
		
		JMenuItem update = new JMenuItem("Update Current Project");
		project.add(update);
		update.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				//TODO
			}
		});
		JMenu image = new JMenu("Image");
		this.add(image);
		
		JMenuItem addToImageServer = new JMenuItem("Add to Image Server");
		image.add(addToImageServer);
		addToImageServer.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				new ImageRegisterDialog(WorkspaceWindow.getInstance(), "Add Image to Image Server").setVisible(true);				
			}
		});

		JMenuItem downloadImage = new JMenuItem("Download");
		image.add(downloadImage);
		downloadImage.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				new ImageDownloadDialog(WorkspaceWindow.getInstance(), "Download Image").setVisible(true);				
			}
		});
		
		JMenuItem addToProject = new JMenuItem("Add to Project");
		image.add(addToProject);
		addToProject.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				ProjectHandler.getInstance().setAction(Constants.ADD_IMAGE);
				ProjectHandler.getInstance().addImages();
			}
		});
		
		
		JMenuItem attachment = new JMenuItem("Attachment");
		attachment.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				ProjectHandler.getInstance().setAction(Constants.ADD_ATTACHMENT);
				ProjectHandler.getInstance().addAttachment();	
			}
			
		});
		this.add(attachment);
	}
	
}
