package smart_gs.network;

import java.util.Date;
import java.util.Hashtable;
import java.util.List;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import smart_gs.debugprint.Debugprint;

import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.HCPUser;


public class ProjectTree extends JTree implements TreeSelectionListener {
	HCPProject project;
	private String location;
	
	public ProjectTree(HCPProject project, String location) {
		super(makeTable(project));
		this.setLoc(location);
		this.addTreeSelectionListener(this);
		this.expandPath(new TreePath(this.getModel().getRoot()));
	}

	private static Hashtable<String, Object> makeTable(HCPProject project) {
		Hashtable<String, Object> root = new Hashtable<String, Object>();
		Hashtable<String, Object> contents = new Hashtable<String, Object>();
		List<HCPDocument> documents = project.documents;
		for (int i = 0; i < documents.size(); i++) {
			contents.put(documents.get(i).id, documents.get(i));
		}

		Hashtable<String, Object> imageTable = new Hashtable<String, Object>();
		List<HCPMaterial> materials = project.materials;
		for (int i = 0; i < materials.size(); i++) {
			imageTable.put(materials.get(i).id, materials.get(i));
		}
		contents.put("Images", imageTable);

		Hashtable<String, Object> attachmentTable = new Hashtable<String, Object>();
		List<HCPAttachment> attachments = project.attachments;
		for (int i = 0; i < attachments.size(); i++) {
			attachmentTable.put(attachments.get(i).id, attachments.get(i));
		}
		contents.put("Attachments", attachmentTable);
		root.put(project.name, contents);
		return root;
	}

	private static String detail(HCPProjectContent content) {
		String desc = content.description;
		HCPProjectContent.Record record = content.record;
		Date date = record.modified;
		HCPUser user = record.modifiedBy;
		int rev = record.revision;
		return "revision " + rev + ", " + date + ", " + user.id + " (" + desc + ")";
	}

	public ProjectTree(Hashtable<String, Object> table) {
		super(table);
	}

	public void setLoc(String location) {
		this.location = location;
	}

	public String getLoc() {
		return location;
	}

	@Override
	public void valueChanged(TreeSelectionEvent arg0) {
		TreePath path = this.getSelectionPath();
		DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
		String id = (String)selectedNode.getUserObject();
//		Debugprint.from();
//		Debugprint.message("id: " + id);
		HCPProject project = ProjectExplorer.getInstance().getSelectecProject(this.location);
		HCPDocument doc = null;
		for (int i = 0; i < project.documents.size(); i++) {
			if (project.documents.get(i).id.equals(id)) {
				doc = project.documents.get(i);
				break;
			}
		}
		if (doc != null) {
			ProjectExplorer.getInstance().getProjectContentPreviewPanel().setDocument(doc);
			return;
		}

		HCPMaterial image = null;
		for (int i = 0; i < project.materials.size(); i++) {
			if (project.materials.get(i).id.equals(id)) {
				image = project.materials.get(i);
				break;
			}
		}
		if (image != null) {
			ProjectExplorer.getInstance().getProjectContentPreviewPanel().setImage(image);
			return;
		}
		
		HCPAttachment attachment = null;
		for (int i = 0; i < project.attachments.size(); i++) {
			if (project.attachments.get(i).id.equals(id)) {
				attachment = project.attachments.get(i);
				break;
			}
		}
		if (attachment != null) {
			ProjectExplorer.getInstance().getProjectContentPreviewPanel().setAttachment(attachment);
			return;
		}
	}
	
}
