package smart_gs.network;


import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuBar;


public class ProjectExplorerMenuBar extends JMenuBar {
	
	static final String OPEN = Constants.OPEN;
	static final String AUTHENTICATE = Constants.AUTHENTICATE;
	static final String UPDATE = Constants.UPDATE;
	static final String COMMIT = Constants.COMMIT;
	static final String IMPORT = Constants.IMPORT;
	static final String CHECKOUT = Constants.CHECKOUT;
	static final String EXPORT = Constants.EXPORT;
	static final String CREATE = Constants.CREATE;
	static final String COMPARE = Constants.COMPARE;
	static final String REMOVE = Constants.REMOVE;
//	static final String ADD_IMAGE = Constants.ADD_IMAGE;
	public ProjectExplorerMenuBar() {
		ProjectActionButton open = new ProjectActionButton(new ProjectAction(OPEN));
		this.add(open);
		ProjectActionButton auth = new ProjectActionButton(new ProjectAction(AUTHENTICATE));
		this.add(auth);
		ProjectActionButton update = new ProjectActionButton(new ProjectAction(UPDATE));
		this.add(update);
		ProjectActionButton commit = new ProjectActionButton(new ProjectAction(COMMIT));
		this.add(commit);
		ProjectActionButton imprt = new ProjectActionButton(new ProjectAction(IMPORT));
		this.add(imprt);
		ProjectActionButton checkout = new ProjectActionButton(new ProjectAction(CHECKOUT));
		this.add(checkout);
		ProjectActionButton export = new ProjectActionButton(new ProjectAction(EXPORT));
		this.add(export);
		ProjectActionButton create = new ProjectActionButton(new ProjectAction(CREATE));
		this.add(create);
		ProjectActionButton compare = new ProjectActionButton(new ProjectAction(COMPARE));
		this.add(compare);
		ProjectActionButton remove = new ProjectActionButton(new ProjectAction(REMOVE));
		this.add(remove);

	}
	
	class ProjectActionButton extends JButton {
		
		public ProjectActionButton(ProjectAction projectAction) {
			super(projectAction);
		}
		
		public String relevantLocation() {
			String name =(String) ((ProjectAction)this.getAction()).getValue(AbstractAction.NAME);
			if (name.equals(OPEN) || name.equals(UPDATE) ||
					name.equals(COMMIT) || name.equals(IMPORT) ||
					name.equals(REMOVE)) {
				return Constants.WORKSPACE;
			}
			if (name.equals(CHECKOUT) || name.equals(EXPORT)) {
				return Constants.REPOSITORY;
			} else {
				return Constants.NONE;
			}
		}
	}

}
