package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;

import smart_gs.debugprint.Debugprint;
import smart_gs.logical.Preference;

import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectContentPreviewPanel extends JPanel {
	private HCPDocument document;
	private HCPMaterial material;
	private HCPAttachment attachment;
	private JScrollPane sPane;
	private JTextArea textArea;
	private JLabel label;
	private HCPMaterial image;
	
	public ProjectContentPreviewPanel() {
		super();
		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		this.textArea = new JTextArea();
		this.textArea.setWrapStyleWord(true);
		this.textArea.setAutoscrolls(true);
		this.textArea.setEditable(false);
		this.textArea.setText("");
		this.sPane = new JScrollPane(this.textArea);
		this.sPane.setLayout(new ScrollPaneLayout());
		this.sPane.setSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
		this.add(this.sPane);
		this.updateUI();
	}

	public void setDocument(HCPDocument doc) {
		this.document = doc;
		this.textArea.setText(doc.source);
		this.textArea.setEditable(false);
		this.sPane = new JScrollPane(this.textArea);
		this.removeAll();
		this.add(this.sPane);
		this.updateUI();
	}
	
	public void setImage(HCPMaterial image) {
		this.image = image;
		String path = Preference.getInstance().getWorkspaceDirectory() + File.separator + "image" + image.imagePath;
		Debugprint.from("ProjectContentPreviewPanel, setImage(HCPMaterial image)");
		Debugprint.message("image.imagePath: " + path);
		this.label = new JLabel();
		this.label.setIcon(new ImageIcon(path));
		this.sPane = new JScrollPane(this.label);
		this.removeAll();
		this.add(this.sPane);
		this.updateUI();
	}

	public void setAttachment(HCPAttachment attachment) {
//		Debugprint.from("ProjectContentPreviewPanel, setAttachment(HCPAttachment attachment)");
		HCPProject project = ProjectExplorer.getInstance().getSelectedProjectInWorkspace();
//		Debugprint.message("project: " + project);
		String workspaceDir = Preference.getInstance().getWorkspaceDirectory();
		this.attachment = attachment;
		String inputFileName = workspaceDir + File.separator + "repository" 
							+ File.separator + project.name
							+ File.separator + "attachment"
							+ File.separator + attachment.filePath;
		
//		Debugprint.message("inputFileName: " + inputFileName);
		File inputFile = new File(inputFileName);
		try {
			FileInputStream fis = new FileInputStream(inputFile);
			BufferedInputStream bis = new BufferedInputStream(fis);
			byte[] buf = new byte[1024];
			int len = bis.read(buf);
			String hex = "";
			for ( int i = 0; i < len; i++ ) {
				hex += String.format("%1$x ", buf[i]);
			}
			this.textArea.setText(hex);
			this.textArea.setEditable(false);
			this.sPane = new JScrollPane(this.textArea);
			this.removeAll();
			this.add(this.sPane);
			this.updateUI();
			bis.close();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	

}
