package smart_gs.network;

import java.awt.BorderLayout;
import java.util.Hashtable;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectContentPanel extends JPanel {
	
	private HCPProject project;
	
	public ProjectContentPanel() {
		JLabel label = new JLabel();
		label.setText("No project");
		this.add(label);
	}
	
	public ProjectContentPanel(HCPProject project, String location) {
		this();
		this.project = project;
		ProjectTree tree = new ProjectTree(this.project, location);
		this.add(tree);
	}

	public void reset(HCPProject project, String location) {
		this.removeAll();
		this.project = project;
		ProjectTree tree = new ProjectTree(this.project, location);
		JScrollPane sPane = new JScrollPane(tree);
		this.add(sPane);
		this.updateUI();
	}

}
