package smart_gs.network;

import java.awt.event.ActionEvent;
import java.io.IOException;

import javax.swing.AbstractAction;
import javax.swing.Action;

import smart_gs.debugprint.Debugprint;

import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;

class ProjectAction extends AbstractAction {

	static final String OPEN = Constants.OPEN;
	static final String AUTHENTICATE = Constants.AUTHENTICATE;	
	static final String UPDATE = Constants.UPDATE;
	static final String COMMIT = Constants.COMMIT;
	static final String IMPORT = Constants.IMPORT;
	static final String CHECKOUT = Constants.CHECKOUT;
	static final String EXPORT = Constants.EXPORT;
	static final String CREATE = Constants.CREATE;
	static final String COMPARE = Constants.COMPARE;
	static final String REMOVE = Constants.REMOVE;
	static final String ADD_IMAGE = Constants.ADD_IMAGE;
	
	ProjectAction(String name) {
		putValue(Action.NAME, name);
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		String name = (String) this.getValue(Action.NAME);
		HCPProject projectInWorkspace = ProjectExplorer.getInstance().getSelectedProjectInWorkspace();
		HCPProject projectInRepository = ProjectExplorer.getInstance().getSelectedProjectInRepository();
		ProjectHandler handler = ProjectHandler.getInstance();
		handler.setProjectInWorkspace(projectInWorkspace);
		handler.setProjectInRepository(projectInRepository);
		handler.setAction(name);
		if (name.equals(AUTHENTICATE)) {
			handler.authenticate();
		} else if (name.equals(OPEN)) {
			handler.open(projectInWorkspace);
		} else if (name.equals(IMPORT)) {
			handler.imprt();
		} else if (name.equals(COMMIT)) {
			handler.commit();
		} else if (name.equals(UPDATE)) {
			handler.update();
		} else if (name.equals(CHECKOUT)) {
			handler.checkout();
		} else if (name.equals(EXPORT)) {
			handler.export();
		} else if (name.equals(COMPARE)) {
			handler.compare();
		} else if (name.equals(CREATE)) {
			handler.create();
		} else if (name.equals(REMOVE)) {
			handler.remove();
		} else if (name.equals(ADD_IMAGE)) {
			handler.addImages();
		}
	}
	
}
