package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import jp.ac.nii.hcp.client.core.ImageContentManager;
import jp.ac.nii.hcp.client.net.AuthenticationCache;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPImage;

import smart_gs.debugprint.Debugprint;
import smart_gs.swingui.ButtonDialog;

public class ImageRegisterDialog extends ButtonDialog {

	private JCheckBox checkBox;
	private JTextField imageURLField;
	private JTextField nameField;

	public ImageRegisterDialog(Frame parent, String title) {
		super(parent, title);
		this.setSize(new Dimension(300,230));

		this.imageURLField = new JTextField();
		imageURLField.setPreferredSize(new Dimension(250, 25));
		JPanel imageURLPanel = new JPanel();
		imageURLPanel.setBorder(new TitledBorder("Image URL"));
		imageURLPanel.add(imageURLField);
		
		this.nameField = new JTextField();
		nameField.setPreferredSize(new Dimension(250, 25));
		JPanel namePanel = new JPanel();
		namePanel.setBorder(new TitledBorder("Image Name"));
		namePanel.add(nameField);

		
		JPanel north = new JPanel();
		north.setLayout(new BorderLayout());
		north.add(imageURLPanel, BorderLayout.NORTH);
		north.add(namePanel, BorderLayout.SOUTH);

		this.checkBox = new JCheckBox();
		JLabel ask = new JLabel();
		ask.setText("Download to workspace.");
		JPanel cbAndAsk = new JPanel();
		cbAndAsk.setLayout(new BorderLayout());
		cbAndAsk.add(checkBox, BorderLayout.WEST);
		cbAndAsk.add(ask, BorderLayout.CENTER);
		
		this.getContentPane().add(north, BorderLayout.NORTH);
		this.getContentPane().add(cbAndAsk, BorderLayout.CENTER);
	}

	@Override
	public void ok() {
		ProjectHandler handler = ProjectHandler.getInstance();
		handler.setAction(Constants.RESISTER_IMAGE);
		String name = this.nameField.getText();
		if (name.length() > 16) {
			JOptionPane.showMessageDialog(this, "The name should be not longer than 16 letters.", "ERROR", JOptionPane.ERROR_MESSAGE);
			return;
		}
		if (!handler.authenticated()) {
			handler.authenticate();
		} else {
			ImageContentManager icm = handler.getController().getImageManager();
			AuthenticationCache auth = handler.getAuthenticationCache();
			String url = this.imageURLField.getText();
			try {
				HCPImage image = icm.add(auth.user, name, url);
				if (this.checkBox.isSelected()) {
					String path = image.getPath();
					Debugprint.from("ImageRegisterDialog, ok()");
					Debugprint.message("image path: " + path);
					try {
						icm.download(path, null);
					} catch (IOException e) {
						new ShowResultDialog("Register Image",e);
						e.printStackTrace();
					}
				}
			} catch (IOException e) {
				new ShowResultDialog("Register Image",e);
				e.printStackTrace();
			} catch (HCPClientException e) {
				new ShowResultDialog("Register Image",e);
				e.printStackTrace();
			}
		}
		this.dispose();		
	}

	@Override
	public void cancel() {
		this.dispose();
	}

}

// (1) 摜ǗIuWFNg擾B
//ImageContentManager icm = hcp.getImageManager();

// (2) URLƃpX\w肵āA摜摜URIT[oɓo^B
//HCPImage image1 = icm.add(auth.user, "S09_001", "http://kyoto-gakuha.info/htmlimg/LectureNotesS09_ver2/S09_001.jpg");
//͉摜o^ۂ̉摜̖OŁAꂪpX̗vfɂȂ܂B

//摜̃pXmF
//System.out.println("image7.getPath(): " + image7.getPath());

// (3) 摜摜[NXy[XɃ_E[hB
//ł͉摜̃pX𒼐ڎw肵Ă܂B
//icm.download("/00000005/S09_001", null);

//vWFNgɉ摜ǉ
//editor.addMaterial("/摜/S09_001", image1.getPath(), "S09_001");