package smart_gs.network;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneLayout;

import jp.ac.nii.hcp.client.net.UnauthorizedException;
import jp.ac.nii.hcp.client.shared.HCPClientException;

import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.Region;
import smart_gs.swingui.MemoPadDialog;
import smart_gs.swingui.WorkspaceWindow;

public class CommitDialog extends JDialog implements ActionListener {
	
	private static CommitDialog singleton = new CommitDialog();
	private JScrollPane sPane;
	private JTextArea textArea;
	private JButton ok;
	private JButton cancel;
	private JComboBox<String> recentCommentBox;
	private List<String> recentComments;
	private JLabel label;
	

	public CommitDialog() {
//		super(WorkspaceWindow.getInstance());
		super();
		this.setModal(true);
		String text = "";
		this.textArea = new JTextArea();
		this.textArea.setText(text);
		
		this.sPane = new JScrollPane(textArea);
		this.ok = new JButton("OK");
		this.ok.addActionListener(new OKActionListener());
		this.cancel = new JButton("Cancel");
		this.cancel.addActionListener(new CancelActionListener());
		
		this.label = new JLabel();
		this.label.setText("Recent Comments");
		this.recentComments = new ArrayList<String>();
		this.recentCommentBox = new JComboBox<String>();
		this.recentCommentBox.addActionListener(this);

		this.buildLayout();
		this.setSize(300,250);		
	}

	private void buildLayout() {
		Container pane = this.getContentPane();
		pane.removeAll();
		this.setTitle("Commit Comment");
		this.sPane.setLayout(new ScrollPaneLayout());
		this.getContentPane().add(this.sPane);
		this.getContentPane().add(this.ok);
		this.getContentPane().add(this.cancel);
		GroupLayout layout = new GroupLayout(pane);
		pane.setLayout(layout);
		layout.setAutoCreateGaps(true);
		layout.setAutoCreateContainerGaps(true);
		
		layout.setHorizontalGroup(layout.createSequentialGroup()
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.sPane)
				.addGroup(layout.createSequentialGroup()
						.addComponent(this.ok)
						.addComponent(this.cancel))
				.addComponent(this.label)
				.addComponent(this.recentCommentBox)
			)
		);
	
	
		layout.setVerticalGroup(layout.createSequentialGroup()
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.sPane))
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.ok)
				.addComponent(this.cancel))
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.label))
			.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER)
				.addComponent(this.recentCommentBox)
			)
		);
	}

	public JTextArea getTextArea() {
		return this.textArea;
	}
	
	class OKActionListener implements ActionListener {

		@Override
		public void actionPerformed(ActionEvent arg0) {
			String comment = CommitDialog.getInstance().getTextArea().getText();

			CommitDialog.getInstance().recentComments.add(comment);
			CommitDialog.getInstance().recentCommentBox.addItem(comment);
			ProjectHandler.getInstance().commit();
			System.out.println("Commit comment:" + comment);
			CommitDialog.getInstance().textArea.setText("");
			CommitDialog.getInstance().setVisible(false);
			// TODO Deal with the case where a conflict arises.
			WorkspaceWindow.setUpdated(true);
		}		
	}
	
	class CancelActionListener implements ActionListener {		
		@Override
		public void actionPerformed(ActionEvent arg0) {
			CommitDialog.getInstance().setVisible(false);
		}
		
	}

	public static CommitDialog getInstance() {
		return singleton ;
	}
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		String comment = (String) this.recentCommentBox.getSelectedItem();
		this.textArea.setText(comment);
	}


}
