/* $Id: SetDirectoryPathAction.java 539 2012-08-26 08:42:21Z minao $ */
package smart_gs.menu.action;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFileChooser;
import javax.swing.JFrame;

import smart_gs.menu.DirectorySettingWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
/**
 * Oɂt@CgꍇApathw肷邽߂̃ANV
 * @author Administrator
 *
 */
//2007/11/20 kazuhiro kobayashi
public abstract class SetDirectoryPathAction implements ActionListener {
	protected String dialogTitle;
	protected JFileChooser chooser;
	protected JFrame parent;
	
	public SetDirectoryPathAction(JFrame jFrame){
		//oldPathftHgƂt@C`[ް
		chooser = new JFileChooser(getOldPath());
		chooser.setDialogTitle(this.dialogTitle);
		chooser.setApproveButtonText("Set");
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		this.parent = jFrame;
	}
	
	public SetDirectoryPathAction(){
		chooser = new JFileChooser(getOldPath());
		chooser.setApproveButtonText("Set");
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		this.parent = WorkspaceWindow.getInstance();
	}


	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		this.parent.setAlwaysOnTop(false);
		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if(input == JFileChooser.CANCEL_OPTION){
			this.parent.setAlwaysOnTop(true);
			return;
		}
		this.parent.setAlwaysOnTop(true);
		//IpathŐݒ肷
		validateNewPath(getNewPath());
	}
	protected abstract String getOldPath();
	protected String getNewPath(){
		return CanonicalPathString.get(chooser.getSelectedFile());
	}
	protected abstract void validateNewPath(String newPath);
	

}
