/* $Id: PolygonRegion.java 539 2012-08-26 08:42:21Z minao $ */
package smart_gs.logical.region;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.view.PolygonView;
import smart_gs.drawing_tool.view.LineSegView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.URIObject;

public class PolygonRegion extends Region{

	public PolygonRegion(Spread spread, List<Point2D> points, String uri, String originalURI) {
		super(spread,URIObject.POLYGON);
		this.points = points;
		this.createView();
		this.setURIs(uri, originalURI);
	}

	public PolygonRegion(Spread spread, List<Point2D> points) {
		super(spread,URIObject.POLYGON);
		this.points = points;
		this.createView();
		this.setURIs();
	}



	private void createView(){
		List<ExLine2D> lines = new ArrayList<ExLine2D>();
		for(int i=0;i<this.points.size()-1;i++){
			Point2D start = this.points.get(i);
			Point2D end = this.points.get(i+1);
			ExLine2D line = new ExLine2D(start,end);
			lines.add(line);
		}
		this.view = new PolygonView(lines);
	}
	public Spread getSpread() {
		return this.spread;
	}
	public List<Point2D> getPoints() {
		return this.points;
	}
	public View getView(){
		return this.view;
	}
	@Override
	public String getTypeString() {
		return "polygon";
	}
	
	
}