/* $Id: MultiSelectedState.java 475 2011-12-02 08:46:54Z ohura $ */
package smart_gs.drawing_tool.state;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.Region;
import smart_gs.swingui.GSMouseEvent;

public class MultiSelectedState implements State {
	
	private static MultiSelectedState singleton = new MultiSelectedState();
	
	private List<Region> selectedRegions;
	
	private MultiSelectedState(){
		this.selectedRegions = new ArrayList<Region>();
	}
	public static MultiSelectedState getInstance(){
		return singleton;
	}
	public void addSelectedRegion(Region region){
		this.selectedRegions.add(region);
		region.getView().setIsSelected(true);
	}
	
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas) {
		// TODO Auto-generated method stub
		canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
		
	}

	public void mouseDragged(GSMouseEvent e, SpreadCanvas canvas) {
		// TODO Auto-generated method stub
		canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
		
	}

	public void mouseEntered(GSMouseEvent e, SpreadCanvas canvas) {
		// TODO Auto-generated method stub
		canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
		
	}

	public void mouseExited(GSMouseEvent e, SpreadCanvas canvas) {
		// TODO Auto-generated method stub
		canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
		
	}

	public void mouseMoved(GSMouseEvent e, SpreadCanvas canvas) {
		// TODO Auto-generated method stub
		canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
		
	}

	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		for(int i=0;i<this.selectedRegions.size();i++){
			this.selectedRegions.get(i).getView().setIsEmphasized(false);
		}
		ImageLabel.setState(DefaultState.getInstance());
		canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
	}

	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		// TODO Auto-generated method stub
		canvas.getImageLabel().setCursor(DefaultState.getInstance().getCursor());
		
	}

	public void paint(Graphics g, SpreadCanvas canvas) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public int getType() {
		return State.MULTISELECTED;
	}

}
