/* $Id: MarkerMode.java 539 2012-08-26 08:42:21Z minao $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;


import smart_gs.debugprint.Debugprint;
import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
//import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.MarkerRegion;
import smart_gs.swingui.GSMouseEvent;

public class MarkerMode extends DrawingModeAdapter{
	
	private static Mode singleton = new MarkerMode();
	
	private Point2D start;
	private Point2D end;
	
	private Point2D tempStart;
	private Point2D tempEnd;
	
	public static Mode getInstance(){
		return singleton;
	}
	
	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		super.mousePressed(e, canvas);
		this.start = e.getPoint();
		this.tempStart = e.getOriginalPoint();
	}
	@Override
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
	}
	
	@Override
	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		super.mouseReleased(e, canvas);
		if(start == null || end == null){
			return ;
		}
		canvas.addRegion(new MarkerRegion(canvas.getSpread(),start,end));
		this.start = null;
		this.end = null;
		this.tempStart = null;
		this.tempEnd = null;
//		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
	}
	@Override
	public void paint(Graphics g,SpreadCanvas canvas) {
		super.paint(g,canvas);
		if(this.tempStart == null || this.tempEnd == null){
			return;
		}
		ImageLabel imageLabel = canvas.getImageLabel();
		double ratio = imageLabel.getRatio();
		int canvasWidth = canvas.getWidth();
		int canvasHeight = canvas.getHeight();
		int iconHeight = imageLabel.getIcon().getIconHeight();
		int iconWidth = imageLabel.getIcon().getIconWidth();
		int scrollHeight = canvas.getHorizontalScrollBar().getHeight();
		int scrollWidth = canvas.getVerticalScrollBar().getWidth();
		double gapX = 0;
		double gapY = 0;
		if (iconWidth < canvasWidth) {
			gapX = (canvasWidth - scrollWidth - iconWidth) / 2.0;
		}
		if (iconHeight < canvasHeight) {
			gapY = (canvasHeight - scrollHeight - iconHeight) / 2.0;
		}
		Point2D start = new Point2D.Double(tempStart.getX() / ratio, tempStart.getY() / ratio);
		Point2D end = new Point2D.Double(tempEnd.getX() / ratio, tempEnd.getY() / ratio);
		MarkerView view = new MarkerView(start,end);
		int breadth = new Integer(Preference.getInstance().getMarkerBreadth());
		view.setBreadth(breadth);

		
		view.enlargedView(ratio, gapX, gapY).draw((Graphics2D)g);
//		if(this.start == null || this.end == null){
//			return;
//		}
//		double ratio = canvas.getImageLabel().getRatio();
//		new MarkerView(start,end).enlargedView(ratio).draw((Graphics2D)g);
	}
	
}
