/* $Id: SmartGS.java 539 2012-08-26 08:42:21Z minao $ */
package smart_gs;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;

public class SmartGS {
	
	private static boolean dscFolderSetting = false;
	private static String imageSearchExefilePathString = "";
	private static String imageSearchAssignlistfilePathString = "";
	
	/**
	 * @return the dscFolderSetting
	 */
	public static boolean isDscFolderSetting() {
		return dscFolderSetting;
	}
	/**
	 * @return the exefilePathString
	 */
	public static String getImageSearchExefilePathString() {
		return imageSearchExefilePathString;
	}

	/**
	 * @return the assignlistfilePathString
	 */
	public static String getImageSearchAssignlistfilePathString() {
		return imageSearchAssignlistfilePathString;
	}



	public static void main(String[] args) {
		//20080118 North Grid Add
		
		ArrayList<String> temp = new ArrayList<String>();
		if( args.length > 0 ){
			for(int i = 0; i < args.length; i++){
				if (args[i].startsWith("-")){
					// TODO 2011.10.24 shayashi
//					if (!(args[i].equals("-p") || args[i].equals("-dscfolderpathsetting"))) {
					if (!(args[i].equals("-p") || args[i].equals("-horizontalWindow") || args[i].equals("-dscfolderpathsetting"))) {
						System.out.println("Illegal option " + args[i] + " is neglected.");
						System.out.println("-p: specifying preference file");
						System.out.println("-dscfolderpathsetting: old sytle Date Directories & Files Setting");
					}
				}
			}
			
			for(int j = 0; j < args.length; j++){
				if( args[j].equals("-p") ){
					if( j < args.length-1 ){
						String preferenceFile = args[j+1];
						if(new File(preferenceFile).exists()){
							Preference.setPreferenceFile(preferenceFile);
							System.out.println("Loading from " + preferenceFile + ".");
						}else{
							System.out.println("can't find " + preferenceFile + ". Loading default...");
						}
					}else{
						System.out.println("Invalid parameter. Please set \"-p <preference file>\".  Loading default...");
					}
				}else{
					temp.add(args[j]);
				}
			}
			
			for(int k = 0; k < args.length; k++){
				if (args[k].equals("-dscfolderpathsetting")){
					dscFolderSetting = true;
					break;
				}
			}
			// TODO 2011.10.24 shayashi
			for(int k = 0; k < args.length; k++){
				if (args[k].equals("-horizontalWindow")){
					Preference.setWorkspaceWindowModeToLeft();
					break;
				}
			}
		}
		
//		String [] arguments = new String[temp.size()];
//		for(int i = 0; i < temp.size(); i++){
//			arguments[i] = temp.get(i);
//		}

		File fileCurrent=new File(".");
		
		
// TODO This option has been never used. Abolished for SMART-GS0.8,
//		for the way of specification is not good.
//		However, reconsider to restore it for future versions.
//		if (arguments != null && arguments.length == 2) {
//			exefilePathString = CanonicalPathString.get(fileCurrent) + "/" + arguments[0];
//			assignlistfilePathString = CanonicalPathString.get(fileCurrent) + "/" + arguments[1];
//			System.out.println("DscSearch mode: exefile=\"" + arguments[0] + "\", assignlistfile=\"" + arguments[1] + "\"");
//		}else{
			imageSearchExefilePathString = CanonicalPathString.get(fileCurrent) + "/DscSearch.exe";
			imageSearchAssignlistfilePathString = CanonicalPathString.get(fileCurrent) + "/temp/assignlist";
			System.out.println("DscSearch mode with using default path: exefile=\"" + imageSearchExefilePathString + "\", assignlistfile=\"" + imageSearchAssignlistfilePathString + "\"");
//		}

		WorkspaceWindow workspaceWindow = WorkspaceWindow.getInstance();
		int status = workspaceWindow.getPreferenceLoadStatus();
		
		if (status != 0) {
			workspaceWindow.dispose();
		} else {
			workspaceWindow.setVisible(true);
			workspaceWindow.setFileOpened(true);
		}
	}
}
