/* $Id: GsXMLSaver.java 148 2011-05-01 13:25:14Z shayashi $ */
package smart_gs.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

import smart_gs.logical.Preference;

public class GsXMLSaver {
	private Document document;
	private String filename;

	public GsXMLSaver(Document document, String filename) {
		this.document = document;
		this.filename = filename;
	}

	public synchronized void save() {
		TransformerFactory factory = TransformerFactory.newInstance();
		try {
			Transformer transformer = factory.newTransformer();
			transformer.setOutputProperty("encoding", "UTF-8");
			transformer.setOutputProperty("standalone", "yes");
			transformer.setOutputProperty("indent", "yes");

			DOMSource source = new DOMSource(document);
			File file = new File(filename);

			/*
			 * @memo StreamResultfilenꍇAsegfo2dsc.exe̎sɎsB
			 * 炭At@CbNꂽ܂܂ɂȂĂ̂낤B
			 * ̖ɑΏׁAWriterƂēnAclose()ĂяoĂB Ƃ܂B
			 */
			
			// 2007/11/30 kazuhiro kobayashi
			//DOCTYPE錾sB
			//Agst@CȊOxmlt@Cɂł܂B
			StringWriter output = new StringWriter();
			transformer.transform(source, new StreamResult(output));
			String string = output.toString();
			int p = string.indexOf("?>") + 2;
			String former = string.substring(0, p);
			String latter = string.substring(p + 1);
			String newstring = former
					+ "\n<!DOCTYPE rootElement[\n<!ENTITY rootpath  \""
					+ Preference.getInstance().getSmart_gsFolderPathString()
					+ "\">\n]>"
					/*
					 * &amp;&ɕϊĂB
					 * 
					 */
					+ latter.replaceAll("&amp;rootpath;", "&rootpath;");

			if(file.getName().endsWith(".gsx")||
					file.getName().endsWith(".gsx.auto")) {
				ZipOutputStream writer = new ZipOutputStream(new FileOutputStream(file));
				writer.putNextEntry(new ZipEntry("spread.xml"));
				writer.write(newstring.getBytes("UTF-8"));
				writer.close();
			} else {
				OutputStreamWriter writer = new OutputStreamWriter(
						new FileOutputStream(file), "UTF-8");
				writer.write(newstring);
				writer.close();
			}
			transformer = null;
			file = null;
			source = null;
		} catch (TransformerConfigurationException e1) {
			e1.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		factory = null;
	}
}
