/* $Id: SearchResultViewer.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.text_search.swingui;


import java.awt.*;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import smart_gs.text_search.swingui.ResultListPanel;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.text_search.swingui.ResultPanel;

@SuppressWarnings("serial")
public class SearchResultViewer extends JFrame{


	private JPanel queryPanel;
	private ResultListPanel resultListPanel;
	private JPanel buttonPanel;
	private JButton backButton;
	private JButton nextButton;
	private final int SIZE_TO_DISPLAY = 10;
	
	public SearchResultViewer(String queryText, ArrayList<SearchResult> results){
		super("Search Dialog");
		JPanel mainPanel = new JPanel();
		this.add(mainPanel, BorderLayout.CENTER);
		mainPanel.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		this.setSize(400,800);
		this.queryPanel = new JPanel();
		queryPanel.setLayout(new BorderLayout());
		JTextField queryField = new JTextField();
		queryField.setHorizontalAlignment(SwingConstants.LEFT);
		queryField.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		queryField.setText(queryText);
		queryField.setBackground( Color.white );
		queryField.setOpaque(true);
		queryField.setEditable(false);
		queryField.setPreferredSize(new Dimension(380, 40));
		queryPanel.add(queryField,BorderLayout.WEST);
		mainPanel.add(queryPanel,BorderLayout.NORTH);
		queryPanel.setBorder(new TitledBorder("query text:"));
		resultListPanel = new ResultListPanel(queryText, SIZE_TO_DISPLAY, results.size(), results); 
		mainPanel.add(resultListPanel,BorderLayout.CENTER);
		buttonPanel = new JPanel();
		backButton = new JButton("Back");
		backButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultListPanel.back();
				validate();
			}
		});	
		nextButton = new JButton("Next");
		nextButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultListPanel.next();
				validate();
			}
		});
		buttonPanel.add(backButton);
		buttonPanel.add(nextButton);
		mainPanel.add(buttonPanel,BorderLayout.SOUTH);
	}	
}