/* $Id: ToolBarPanel.java 133 2011-04-03 10:39:01Z ohura $ */
package smart_gs.swingui;

import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;

import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.toolbar.ConnectionToolBar;
import smart_gs.swingui.toolbar.DefaultToolBar;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.LineSegmentToolBar;
import smart_gs.swingui.toolbar.MoveTreeToolBar;
import smart_gs.swingui.toolbar.UtilityToolBar;
import smart_gs.swingui.toolbar.SearchToolBar;
import sml_editor.swingui.EditorTextPane;
@SuppressWarnings("serial")
public class ToolBarPanel extends JPanel{
	
	private GSEditorToolBar editorToolBar;
	private HistoryToolBar historyToolBar;
	private MoveTreeToolBar moveTreeToolBar;

	public ToolBarPanel(AbstractGSWindow parent){
		super(new GridLayout(2,1));

		JPanel panel1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		panel1.add(new DefaultToolBar());
		panel1.add(new ImageToolBar(parent));
		panel1.add(new SearchToolBar(parent));
		this.add(panel1);
		
		JPanel panel2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		panel2.add(new LineSegmentToolBar(parent));
		panel2.add(new UtilityToolBar(parent));
		historyToolBar = new HistoryToolBar(parent);
		panel2.add(historyToolBar);
		moveTreeToolBar = new MoveTreeToolBar(parent);
		panel2.add(moveTreeToolBar);
		this.add(panel2);
	}

	public void setEditorTextPane(EditorTextPane textPane){
		this.validate();
	}

	public GSEditorToolBar getGSEditorToolBar(){
		return editorToolBar;
	}
	public HistoryToolBar getHistoryToolBar(){
		return historyToolBar;
	}
	public MoveTreeToolBar getMoveTreeToolBar(){
		return moveTreeToolBar;
	}
}
