/* $Id: RWMenubar.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬: 2006/06/10
 *
 */
package smart_gs.reasoning_web.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

import smart_gs.reasoning_web.logical.GSChangeImpactAnalysis;
import smart_gs.reasoning_web.logical.GSChangeImpactAnalysis2;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.action.SetRWBackgroundAction;

/**
 * @author kazuaki kobayashi
 * 
 * 
 */
@SuppressWarnings("serial")
public class RWMenubar extends JMenuBar {

	public RWMenubar() {
		JMenu file = new JMenu("File");
		JMenuItem save = new JMenuItem("save");
		file.add(save);
		//20080622 shimizu wrote
		//this.add(file);

		JMenu tool = new JMenu("Tool");
		JMenu ciAnalysis = new JMenu("Change Impact Analysis");
		JMenuItem ci = new JMenuItem("analysis1");
		ciAnalysis.add(ci);
		ci.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				GS_RWElement element = GlobalViewPanel.getInstance()
						.getSelectedElement();
				GSResourcePointer changeSource = GS_RWRepository.getInstance()
						.getResourcePointer(element);
				new GSChangeImpactAnalysis(changeSource).execute();
			}
		});

		JMenuItem ci2 = new JMenuItem("analysis2");
		ciAnalysis.add(ci2);
		ci2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				GS_RWElement element = GlobalViewPanel.getInstance()
						.getSelectedElement();
				GSResourcePointer changeSource = GS_RWRepository.getInstance()
						.getResourcePointer(element);
				new GSChangeImpactAnalysis2(changeSource).execute();
			}
		});

		tool.add(ciAnalysis);
		//20080622 shimizu wrote
		//this.add(tool);

		// 2007/11/13 kazuhiro kobayashi
		JMenu imageMenu = new JMenu("image");
		JMenuItem setBackground = new JMenuItem("set background");

		//2007/12/8 kazuhiro kobayshi
		setBackground.addActionListener(new SetRWBackgroundAction());
		imageMenu.add(setBackground);

		JMenu visibility = new JMenu("set visibility");
		JMenuItem v1 = new JMenuItem("0.1");
		v1.addActionListener(new SetVisibilityAction(0.1f, v1));
		visibility.add(v1);
		JMenuItem v2 = new JMenuItem("0.2");
		v2.addActionListener(new SetVisibilityAction(0.2f, v2));
		visibility.add(v2);
		JMenuItem v3 = new JMenuItem("0.3");
		v3.addActionListener(new SetVisibilityAction(0.3f, v3));
		visibility.add(v3);
		JMenuItem v4 = new JMenuItem("0.4");
		v4.addActionListener(new SetVisibilityAction(0.4f, v4));
		visibility.add(v4);
		JMenuItem v5 = new JMenuItem("0.5");
		v5.addActionListener(new SetVisibilityAction(0.5f, v5));
		visibility.add(v5);
		JMenuItem v6 = new JMenuItem("0.6");
		v6.addActionListener(new SetVisibilityAction(0.6f, v6));
		visibility.add(v6);
		JMenuItem v7 = new JMenuItem("0.7");
		v7.addActionListener(new SetVisibilityAction(0.7f, v7));
		visibility.add(v7);
		JMenuItem v8 = new JMenuItem("0.8");
		v8.addActionListener(new SetVisibilityAction(0.8f, v8));
		visibility.add(v8);
		JMenuItem v9 = new JMenuItem("0.9");
		v9.addActionListener(new SetVisibilityAction(0.9f, v9));
		visibility.add(v9);
		JMenuItem v10 = new JMenuItem("1.0");
		v10.addActionListener(new SetVisibilityAction(1.0f, v10));
		visibility.add(v10);
		imageMenu.add(visibility);
		this.add(imageMenu);
		//
	}

	// 2007/11/13 kazuhiro kobayshi
	class SetVisibilityAction implements ActionListener {
		private float visibility;

		// private JMenuItem c;
		public SetVisibilityAction(float v, JMenuItem c) {
			visibility = v;
			// this.c = c;
		}

		public void actionPerformed(ActionEvent e) {
			GlobalViewPanel.getInstance().setVisibility(visibility);
		}
	}

}
