/* $Id: GSExplanatoryNote.java 162 2011-05-15 15:37:47Z shayashi $ */
package smart_gs.reasoning_web.logical;

import javax.swing.JPanel;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.ConvertGS;
import smart_gs.logical.GSResource;
import smart_gs.logical.TextSegment;
import smart_gs.logical.visitor.Visitor;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;

public class GSExplanatoryNote extends ExplanatoryNote implements GS_RWElement{
	
	public GSExplanatoryNote(String source, String uri, String originalURI) {
		super(source, uri, originalURI);
	}
	// 200902027 Delete NorthGird
/*	public JPanel createElementViewPanel() throws NoWayToShowException {
		ExplanatoryNoteDialog dialog = new ExplanatoryNoteDialog(this);
		dialog.setEnabled(false);
		return dialog.getLocalViewPanel();
	}
	//2007/11/2 kazuhiro kobayashi 
	public ExplanatoryNoteDialog createDialog() throws NoWayToShowException{
		return new ExplanatoryNoteDialog(this);
	}

	public JPanel getLocalViewPanel(ExplanatoryNoteDialog dialog){
		return dialog.getLocalViewPanel();
	}
	
	public GSEditorTextPane getTextPane(ExplanatoryNoteDialog dialog){
		dialog.setEnabled(false);
		return dialog.getTextPane();
	}
	*/
	public GSEditorTextPane createText(){
		String xml = this.getSource();;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		GSEditorTextPane textPane = new GSEditorTextPane(this,source,GSEditorTextPane.BASIC);
		textPane.setMarkup(false);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));

		return textPane;
	}
	
	//
	
	public String getURI() {
		return this.uri;
	}
	public GSResource getTextSegmentByURI(String uri) {
		//debug
		System.out.println("debug print from GSExplanatoryNote, getTextSegmentByURI(uri)");
		System.out.println("  uri: " + uri);
		for(int i=0;i<this.segments.size();i++){
			System.out.println("  segments.get(" + i + ") uri: " + segments.get(i).getURI());
			System.out.println("  segments.get(" + i + ") old version uri: " + segments.get(i).getOldVersionURI());
			if(this.segments.get(i).getURI().equals(uri)
					|| this.segments.get(i).getOldVersionURI().equals(uri))
			{
				System.out.println("return segments.get(" + i + ")");
				return this.segments.get(i);
			}
		}
		System.out.println("return null");
		return null;
	}
	public static GSExplanatoryNote restore(Element noteElement) {
		String uri = noteElement.getAttribute("uri");
		String originalURI = noteElement.getAttribute(GSResource.ORIGINAL_URI);
		int id = new Integer(noteElement.getAttribute("id"));
		GSExplanatoryNote note = null;
		note = ExpNoteManager.getInstance().getExplanatoryNote(id);
		if(note == null){
			String source = noteElement.getAttribute("source");
			if(!source.startsWith("<xml><html>")){
				try{
					ConvertGS convertGS = new ConvertGS(source);
					source = convertGS.parser();
					if(source.equals("")){
						source = "<xml><html></html></xml>";
					}else{
						source = "<xml><html>" + source + "</html></xml>";
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
            String name = noteElement.getAttribute("name");
			note = new GSExplanatoryNote(source,uri,originalURI);
			note.setName(name);
			NodeList list = noteElement.getElementsByTagName("segment");
			for(int i=0;i<list.getLength();i++){
				TextSegment segment = TextSegment.restore((Element)list.item(i));
				note.addTextSegment(segment);
				segment.setSmartDocument(note);
			}
		}
	    return note;
	}
	// @Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
}
