/* $Id: ShortCutListPanel.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.desktop.swingui;


import java.awt.BorderLayout;
import java.awt.Color;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.swingui.MemoPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;

@SuppressWarnings("serial")
public class ShortCutListPanel extends JPanel implements Observer, ListSelectionListener{
	
	private JList list;
	private DeskTopFolder folder;
	
	private MemoPanel memoPanel;
	
	public ShortCutListPanel(DeskTopFolder folder){
		JLabel label = new JLabel("Elements");
		label.setBorder(new LineBorder(Color.BLACK));
		this.list = new JList();
		this.folder = folder;
		this.setLayout(new BorderLayout());
		
		this.add(label,BorderLayout.NORTH);
		List<DesktopElement> elements = this.folder.getAllElements();
		this.list.setListData(elements.toArray());
		
		this.list.addListSelectionListener(this);
		this.add(this.list,BorderLayout.CENTER);
	}

	
	public void reload(){
		this.list.removeAll();
		List<DesktopElement> elements = this.folder.getAllElements();
		this.list.setListData(elements.toArray());
		this.validate();
	}

	public void update() {
		this.reload();
	}
	//2007.06.11 Tsukushi Shimizu
	public void update(DeskTopFolder folder) {
		this.folder = folder;
		this.reload();
	}	
	public void setMemoPanel(MemoPanel memoPanel){
		this.memoPanel = memoPanel;
	}
	public void valueChanged(ListSelectionEvent e) {
		DesktopElement element = (DesktopElement)this.list.getSelectedValue();
		if(element == null || memoPanel == null){
			return;
		}
		memoPanel.setElement(element);
		ReasoningWebFrame.getInstance().repaint();
	}

	public void setSelectedElement(DesktopElement selectedElement) {
		this.list.setSelectedValue(selectedElement,true);
		this.memoPanel.setElement(selectedElement);
		
	}


	public DesktopElement getSelectedElement() {
		return (DesktopElement) this.list.getSelectedValue();
	}
	
	
	
	
}
