/* $Id: DirectorySettingWindow.java 158 2011-05-08 11:01:20Z ohura $ */
package smart_gs.menu;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import smart_gs.logical.Preference;
import smart_gs.menu.action.SetCurrentDirectoryAction;
import smart_gs.menu.action.SetDictionaryFilePathAction;
import smart_gs.menu.action.SetDocumentFolderPathAction;
import smart_gs.menu.action.SetDscFolderPathAction;
import smart_gs.menu.action.SetImageFolderPathAction;
import smart_gs.menu.action.SetLineFolderPathAction;
import smart_gs.menu.action.SetNameCorrespondenceAction;
import smart_gs.menu.action.SetRWBackgroundFilePathAction;
import smart_gs.menu.action.SetSmart_gsFolderPathAction;
import smart_gs.swingui.ButtonFrame;

/**
 * etH_̃pXݒ肷EBhE
 * 
 * @author kaszuhiro kobayashi
 * 
 */
@SuppressWarnings("serial")
public class DirectorySettingWindow extends ButtonFrame implements
		ActionListener {

	private JPanel directorySettingPanel;

	private JPanel smart_gsFolderPanel;
	private JTextField smart_gsTextField;

	private JPanel gsFolderPanel;
	private JTextField gsTextField;

	private JPanel imageFolderPanel;
	private JTextField imageTextField;

	private JPanel textDocumentFolderPanel;
	private JTextField textDocumentTextField;
	
	private JPanel nameCorrespondenceFolderPanel;
	private JTextField nameCorrespondenceTextField;
	
	
	private JPanel dscFolderPanel;
	private JTextField dscTextField;

	private JPanel lineFolderPanel;
	private JTextField lineTextField;

	private JPanel defaultGsFilePanel;
	private JTextField defaultGsFileTextField;

	// 2007/12/8 kazuhiro kobayashi
	private JPanel RWBackgroundFilePanel;
	private JTextField RWBackgroundFileTextField;

	// 2009/09/09 NorthGird
	private JPanel dictionaryFilePanel;
	private JTextField dictionaryFileTextField;

	
	private static DirectorySettingWindow singleton = new DirectorySettingWindow();

	public static DirectorySettingWindow getInstance() {
		return singleton;
	}

	public DirectorySettingWindow() {
		super("directory setting");

		this.setAlwaysOnTop(true);
		this.setResizable(false);

		this.directorySettingPanel = new JPanel(new GridLayout(9, 1));

		this.smart_gsFolderPanel = new JPanel(new FlowLayout());
		this.smart_gsFolderPanel.setBorder(new TitledBorder("smart_gs"));
		this.smart_gsTextField = new JTextField(20);
		this.smart_gsTextField.setText(Preference.getInstance().getSmart_gsFolderPathString());
		JButton smart_gsReferenceButton = new JButton("Select ...");
		SetSmart_gsFolderPathAction smart_gsAction = new SetSmart_gsFolderPathAction();
		smart_gsReferenceButton.addActionListener(smart_gsAction);
		this.smart_gsFolderPanel.add(smart_gsTextField);
		this.smart_gsFolderPanel.add(smart_gsReferenceButton);

		this.gsFolderPanel = new JPanel(new FlowLayout());
		this.gsFolderPanel.setBorder(new TitledBorder("gs"));
		this.gsTextField = new JTextField(20);
		this.gsTextField.setText(Preference.getInstance().getGsFolderPathString());
		JButton gsReferenceButton = new JButton("Select ...");
		SetCurrentDirectoryAction gsAction = new SetCurrentDirectoryAction();
		gsReferenceButton.addActionListener(gsAction);
		this.gsFolderPanel.add(gsTextField);
		this.gsFolderPanel.add(gsReferenceButton);

		this.imageFolderPanel = new JPanel(new FlowLayout());
		this.imageFolderPanel.setBorder(new TitledBorder("image"));
		this.imageTextField = new JTextField(20);
		this.imageTextField.setText(Preference.getInstance()
				.getImageFolderPathString());
		JButton imageReferenceButton = new JButton("Select ...");
		SetImageFolderPathAction imageAction = new SetImageFolderPathAction();
		imageReferenceButton.addActionListener(imageAction);
		this.imageFolderPanel.add(imageTextField);
		this.imageFolderPanel.add(imageReferenceButton);

		this.textDocumentFolderPanel = new JPanel(new FlowLayout());
		this.textDocumentFolderPanel
				.setBorder(new TitledBorder("textDocument"));
		this.textDocumentTextField = new JTextField(20);
		this.textDocumentTextField.setText(Preference.getInstance()
				.getTextFolderPathString());
		JButton textDocumentReferenceButton = new JButton("Select ...");
		SetDocumentFolderPathAction textDocumentAction = new SetDocumentFolderPathAction();
		textDocumentReferenceButton.addActionListener(textDocumentAction);
		this.textDocumentFolderPanel.add(textDocumentTextField);
		this.textDocumentFolderPanel.add(textDocumentReferenceButton);
		
		this.nameCorrespondenceFolderPanel = new JPanel(new FlowLayout());
		this.nameCorrespondenceFolderPanel.setBorder(new TitledBorder(
				"nameCorrespondence (file name must be \" *.csv \")"));
		this.nameCorrespondenceTextField = new JTextField(20);
		this.nameCorrespondenceTextField.setText(Preference.getInstance()
				.getNameCorrespondencePath());
		JButton nameCorrespondenceReferenceButton = new JButton("Select ...");
		SetNameCorrespondenceAction nameCorrespondenceAction = new SetNameCorrespondenceAction();
		nameCorrespondenceReferenceButton
				.addActionListener(nameCorrespondenceAction);
		this.nameCorrespondenceFolderPanel.add(nameCorrespondenceTextField);
		this.nameCorrespondenceFolderPanel
				.add(nameCorrespondenceReferenceButton);
	

		this.dscFolderPanel = new JPanel(new FlowLayout());
		this.dscFolderPanel.setBorder(new TitledBorder("dsc"));
		this.dscTextField = new JTextField(20);
		this.dscTextField.setText(Preference.getInstance().getDscFolderPathString());
		JButton dscReferenceButton = new JButton("Select ...");
		SetDscFolderPathAction dscAction = new SetDscFolderPathAction();
		dscReferenceButton.addActionListener(dscAction);
		this.dscFolderPanel.add(dscTextField);
		this.dscFolderPanel.add(dscReferenceButton);

		this.lineFolderPanel = new JPanel(new FlowLayout());
		this.lineFolderPanel.setBorder(new TitledBorder("line"));
		this.lineTextField = new JTextField(20);
		this.lineTextField
				.setText(Preference.getInstance().getLineFolderPathString());
		JButton lineReferenceButton = new JButton("Select ...");
		SetLineFolderPathAction lineAction = new SetLineFolderPathAction();
		lineReferenceButton.addActionListener(lineAction);
		this.lineFolderPanel.add(lineTextField);
		this.lineFolderPanel.add(lineReferenceButton);

		this.defaultGsFilePanel = new JPanel(new FlowLayout());
		this.defaultGsFilePanel.setBorder(new TitledBorder("default gs file"));
		this.defaultGsFileTextField = new JTextField(20);
		this.defaultGsFileTextField.setText(Preference.getInstance()
				.getDefaultGsFilePathString());
		JButton defaultGsFileReferenceButton = new JButton("Select ...");
		SetDefaultGsFileAction defaultGsFileAction = new SetDefaultGsFileAction();
		defaultGsFileReferenceButton.addActionListener(defaultGsFileAction);
		this.defaultGsFilePanel.add(this.defaultGsFileTextField);
		this.defaultGsFilePanel.add(defaultGsFileReferenceButton);

		this.RWBackgroundFilePanel = new JPanel(new FlowLayout());
		this.RWBackgroundFilePanel.setBorder(new TitledBorder(
				"RW background file"));
		this.RWBackgroundFileTextField = new JTextField(20);
		this.RWBackgroundFileTextField.setText(Preference.getInstance()
				.getRWBackgroundFilePathString());
		JButton RWBackgroundFileReferenceButton = new JButton("Select ...");
		SetRWBackgroundFilePathAction RWBackgroundFileAction = new SetRWBackgroundFilePathAction();
		RWBackgroundFileReferenceButton
				.addActionListener(RWBackgroundFileAction);
		this.RWBackgroundFilePanel.add(this.RWBackgroundFileTextField);
		this.RWBackgroundFilePanel.add(RWBackgroundFileReferenceButton);

		
		
		this.dictionaryFilePanel = new JPanel(new FlowLayout());
		this.dictionaryFilePanel.setBorder(new TitledBorder("Dictionary file"));
		this.dictionaryFileTextField = new JTextField(20);
		this.dictionaryFileTextField.setText(Preference.getInstance().getDictionary());
		JButton dictionaryFileReferenceButton = new JButton("Select ...");
		SetDictionaryFilePathAction dictionaryFileAction = new SetDictionaryFilePathAction();
		dictionaryFileReferenceButton.addActionListener(dictionaryFileAction);
		this.dictionaryFilePanel.add(this.dictionaryFileTextField);
		this.dictionaryFilePanel.add(dictionaryFileReferenceButton);

		
		this.directorySettingPanel.add(this.smart_gsFolderPanel);
		this.directorySettingPanel.add(this.gsFolderPanel);
		this.directorySettingPanel.add(this.imageFolderPanel);
		this.directorySettingPanel.add(this.textDocumentFolderPanel);
		this.directorySettingPanel.add(this.dscFolderPanel);
		this.directorySettingPanel.add(this.lineFolderPanel);
		// 20080909 nameCorrespondance  gui 폜@hashimoto
		// ɖ߂ۂ smart_gs.menu.action.SetNameCorrespondenceAction.validateNewPath()Ĉ
		// this.directorySettingPanel.add(this.nameCorrespondenceFolderPanel);
		this.directorySettingPanel.add(this.defaultGsFilePanel);

		this.directorySettingPanel.add(this.RWBackgroundFilePanel);
		this.directorySettingPanel.add(this.dictionaryFilePanel);

		this.getContentPane().add(directorySettingPanel, BorderLayout.CENTER);
		this.pack();

	}

	/**
	 * smart_gsFolderPathݒ肷ƁAnameCorrespondence
	 * ̃tH_̃pXsmart_gsFolderPath̉ɎIɐݒ肷
	 * 
	 * @param path
	 */
	public void setSmart_gsTextField(String path) {
		this.smart_gsTextField.setText(path);
		if (!path.endsWith("/")) path = path + "/";
		this.setGsTextField(path + "gs/");
		this.setImageTextField(path + "images/");
		this.setTextDocumentTextField(path + "textDocuments/");
		this.setDscTextField(path + "dsc/");
		this.setLineTextField(path + "lines/");
//		this.setNameCorrespondenceTextField("");
	}

	public void setGsTextField(String path) {
		this.gsTextField.setText(path);
	}

	public void setImageTextField(String path) {
		this.imageTextField.setText(path);
	}

	public void setTextDocumentTextField(String path) {
		this.textDocumentTextField.setText(path);
	}

//	public void setNameCorrespondenceTextField(String path) {
//		this.nameCorrespondenceTextField.setText(path);
//	}

	public void setDscTextField(String path) {
		this.dscTextField.setText(path);
	}

	public void setLineTextField(String path) {
		this.lineTextField.setText(path);
	}

	public void setDefaultGsFileField(String path) {
		this.defaultGsFileTextField.setText(path);
	}

	public void setRWBackgroundFileField(String path) {
		this.RWBackgroundFileTextField.setText(path);
	}
	public void setDictionaryFileTextField(String path) {
		this.dictionaryFileTextField.setText(path);
	}

	public void ok() {
		try {
			Preference.getInstance().setSmart_gsFolderPathString(
					this.smart_gsTextField.getText());
			Preference.getInstance()
					.setGsFolderPathString(this.gsTextField.getText());
			Preference.getInstance().setImageFolderPathString(
					this.imageTextField.getText());
			Preference.getInstance().setTextFolderPathString(
					this.textDocumentTextField.getText());
			Preference.getInstance().setDscFolderPathString(
					this.dscTextField.getText());
			Preference.getInstance().setLineFolderPathString(
					this.lineTextField.getText());
			if (this.defaultGsFileTextField.getText().endsWith(".gs")
					|| this.defaultGsFileTextField.getText().endsWith(".gsx")
					|| this.defaultGsFileTextField.getText().equals("")) {
				Preference.getInstance().setDefaultGsFilePath(
						this.defaultGsFileTextField.getText());
			} else {
				throw new GsFileNameFormatException();
			}
			if (this.nameCorrespondenceTextField.getText().endsWith(".csv")
					|| this.nameCorrespondenceTextField.getText().equals("")) {
				Preference.getInstance().setNameCorrespondencePathString(
						this.nameCorrespondenceTextField.getText());
			} else {
				throw new CsvFileNameFormatException();
			}
			String name = this.RWBackgroundFileTextField.getText();
			if (name.endsWith("png") || name.endsWith("jpg")
					|| name.endsWith("gif") || name.endsWith("JPG")
					|| name.endsWith("JPEG") || name.endsWith("bmp")
					|| name.equals("")) {
				Preference.getInstance().setRWBackgroundFilePathString(name);
			} else {
				throw new RWBackgroundNameFormatException();
			}
			String xml = this.dictionaryFileTextField.getText();
			if (xml.endsWith("xml") || xml.equals("")) {
				Preference.getInstance().setDictionary(xml);
			} else {
				throw new DictionaryException();
			}
			this.dispose();
			JOptionPane.showMessageDialog(null,
					"Reboot SMAR-GS to validate path settings.", "message",
					JOptionPane.INFORMATION_MESSAGE);
		} catch (CsvFileNameFormatException e) {
			// this.setAlwaysOnTop(false);
			// JOptionPane.showConfirmDialog(null,
			// "nameCorrespondenceFile must be \" *.csv \"", "error",
			// JOptionPane.OK_OPTION, JOptionPane.WARNING_MESSAGE);
			// this.setAlwaysOnTop(true);
			e.printStackTrace();
		} catch (GsFileNameFormatException e) {
			e.printStackTrace();
		} catch (RWBackgroundNameFormatException e) {
			e.printStackTrace();
		} catch (DictionaryException e) {
			e.printStackTrace();
		}
	}

	public void cancel() {
		this.dispose();
	}

	class CsvFileNameFormatException extends Exception {
		public CsvFileNameFormatException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane.showConfirmDialog(null,
					"nameCorrespondenceFile must has extension \" *.csv \"", "error",
					JOptionPane.OK_OPTION, JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}

	class GsFileNameFormatException extends Exception {
		public GsFileNameFormatException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane
					.showConfirmDialog(null, "GsFile must has extension \".gs or .gsx\"",
							"error", JOptionPane.OK_OPTION,
							JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}

	class RWBackgroundNameFormatException extends Exception {
		public RWBackgroundNameFormatException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane.showConfirmDialog(null,
					"RWBackground must be image file", "error",
					JOptionPane.OK_OPTION, JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}

	class DictionaryException extends Exception {
		public DictionaryException() {
			singleton.setAlwaysOnTop(false);
			JOptionPane.showConfirmDialog(null,
					"Dictionary must be xml file", "error",
					JOptionPane.OK_OPTION, JOptionPane.WARNING_MESSAGE);
			singleton.setAlwaysOnTop(true);
		}
	}

}
