/* $Id: BrowserSettingDialog.java 148 2011-05-01 13:25:14Z shayashi $ */
package smart_gs.menu;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.BorderLayout;
import javax.swing.JDialog;
import javax.swing.border.TitledBorder;

import smart_gs.logical.Preference;
import smart_gs.menu.action.SetSmart_gsFolderPathAction;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;

import java.awt.Dimension;
import javax.swing.JLabel;
import java.awt.Rectangle;
import java.io.File;

public class BrowserSettingDialog extends JDialog {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;
	private JPanel smart_gsFolderPanel;

	private JLabel jLabel = null;

	private JTextField browserPath = null;

	private JButton selectButton = null;

	private JButton okButton = null;

	private JButton cancelButton = null;
	
	private JDialog jDialog;
	
	/**
	 * @param owner
	 */
	public BrowserSettingDialog(Frame owner) {
		super(owner,true);
		initialize();
		jDialog = this;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(555, 108);
		this.setContentPane(getJContentPane());
		this.setTitle("Select Web Browser");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLabel = new JLabel();
			jLabel.setBounds(new Rectangle(14, 11, 86, 16));
			jLabel.setText("Web Browser");
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(jLabel, null);
			jContentPane.add(getBrowserPath(), null);
			jContentPane.add(getSelectButton(), null);
			jContentPane.add(getOkButton(), null);
			jContentPane.add(getCancelButton(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes BrowserPath	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getBrowserPath() {
		if (browserPath == null) {
			browserPath = new JTextField();
			browserPath.setBounds(new Rectangle(105, 12, 308, 20));
			if(Preference.getInstance().getInstance().getBrowser() != null){
				browserPath.setText(Preference.getInstance().getInstance().getBrowser());
			}
		}
		return browserPath;
	}

	/**
	 * This method initializes selectButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getSelectButton() {
		if (selectButton == null) {
			selectButton = new JButton();
			selectButton.setText("select files...");
			selectButton.setBounds(new Rectangle(418, 12, 116, 20));
			selectButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					JFileChooser chooser = new JFileChooser();
					int returnVal = chooser.showOpenDialog(WorkspaceWindow.getInstance());
					try {
						if (returnVal == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							browserPath.setText(CanonicalPathString.get(file));
						}
					} catch(Exception ex){}
				}
			});
		}
		return selectButton;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton();
			okButton.setBounds(new Rectangle(168, 42, 100, 20));
			okButton.setText("OK");
			okButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					String browser = browserPath.getText();
					if(browser != null){
						Preference.getInstance().getInstance().setBrowser(browser);
					}
					jDialog.setVisible(false);
				}
			});
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton();
			cancelButton.setBounds(new Rectangle(281, 42, 100, 20));
			
			cancelButton.setText("Cancel");
			cancelButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					jDialog.setVisible(false);
				}
			});
		}
		return cancelButton;
	}
	
}  //  @jve:decl-index=0:visual-constraint="10,10"
