/* $Id: XML2ResourceConverter.java 162 2011-05-15 15:37:47Z shayashi $ */
package smart_gs.logical;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.PolygonView;
import smart_gs.drawing_tool.view.LineView;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.region.BookmarkRegion;


public class XML2ResourceConverter {
	
	
	public static GSResource convert(Element element){
		String tagname = element.getNodeName();
		
		if(tagname.equals(URICreator.STANDARD_TEXT_DOCUMENT)){
			return getStandardDocument(element);
		//1028 shimizu wrote;
		}else if(tagname.equals(URICreator.USERS_NOTE)|| tagname.equals("presentation")){
				//shayashi 2011/01/03 presentation-tag is readable for upper compatibility
			return getUsersNote(element);
		}else{
			String uri = element.getAttribute("uri");
			return URISolver.getRegion(uri);
		}
	}
	
	public static Region getRegion(Spread spread,Element element){
		String name = element.getAttribute(GSResource.NAME);
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		
		//debug
		debug1("getRegion(spread,element)", uri, originalURI);
		
		//kazuhiro kobayashi 10/7
		String  protection = element.getAttribute("protection");
		
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("view")){
					String type = elem.getAttribute("type");
					View view = null;
					if(type.equals(URICreator.RECTANGLE)){
						view = RectangleView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI);
						region.setName(name);
						//region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						//debug
						debug2(region.uri, region.originalURI);
						return region;
					}else if(type.equals(URICreator.MARKER)){
						view = MarkerView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI);
						region.setName(name);
						//region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						//debug
						debug2(region.uri, region.originalURI);
						return region;
					}else if(type.equals(URICreator.LINE)){
						view = LineView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI);
						region.setName(name);
						//region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						//debug
						debug2(region.uri, region.originalURI);
						return region;
					}else if(type.equals(URICreator.POLYGON) || type.equals("lasso")){
						//shayashi 2011/01/02 lasso-type is readable for upper compatibility
						view = PolygonView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI);
						region.setName(name);
						//region.setURI(uri);
						//kazuhiro kobayashi 10/7
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						//debug
						debug2(region.uri, region.originalURI);
						return region;
					}else if(type.equals(URICreator.MEMOPAD)){
						view = MemoPadView.restore(elem);
						Region region = new Region(spread,view,uri,originalURI);
						region.setName(name);
						//region.setURI(uri);
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						//debug
						debug2(region.uri, region.originalURI);
						return region;
					} else if(type.equals(URICreator.BOOKMARK)){
						view = BookmarkView.restore(elem);
						Region region = new BookmarkRegion(spread,view,uri,originalURI);
						region.setName(name);
						//region.setURI(uri);
						region.setProtection(protection);
						region.getView().setIsProtected(protection);
						//debug
						debug2(region.uri, region.originalURI);
						return region;
					}
				}
				
			}
		}
		return null;
	}
	
	public static IDAT getIDAT(Spread spread, Element element){
		String type = element.getAttribute("type");
		String leftSource = element.getAttribute("leftSource");
		if(!leftSource.startsWith("<xml><left><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(leftSource);
				leftSource = convertGS.parser();
				if(leftSource.equals("")){
					leftSource = "<xml><left><html></html></left></xml>";
				}else{
					leftSource = "<xml><left><html>" + leftSource + "</html></left></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		String rightSource = element.getAttribute("rightSource");
		if(!rightSource.startsWith("<xml><right><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(rightSource);
				rightSource = convertGS.parser();
				if(rightSource.equals("")){
					rightSource = "<xml><right><html></html></right></xml>";
				}else{
					rightSource = "<xml><right><html>" + rightSource + "</html></right></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		//debug
		debug1("getIDAT(element)", uri, originalURI);

		IDAT doc = null;
		if(type.equals(GSConstants.FIRSTIDAT+"")){
			doc = new FirstIDAT(spread,uri,originalURI);
		}else if(type.equals(GSConstants.SECONDIDAT+"")){
		    doc = new SecondIDAT(spread,uri,originalURI);
		}else if(type.equals(GSConstants.THIRDIDAT+"")){
			doc = new ThirdIDAT(spread,uri,originalURI);

		}
		debug2(doc.uri,doc.originalURI);
		doc.setLeftSource(leftSource);
		doc.setRightSource(rightSource);
		NodeList list = element.getElementsByTagName(URICreator.TEXT_SEGMENT);
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			doc.addTextSegment(segment);
			segment.setSmartDocument(doc);
		}
		return doc;	
	}
	
	public static Spread getSpread(SpreadDirectory parent,Element element){
		String name = element.getAttribute(GSResource.NAME);
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		//debug
		debug1("getSpread(parent,element)",uri,originalURI);
		String filename = element.getAttribute("filename");
		Spread spread = new Spread(parent,new File(filename),uri,originalURI);
//		spread.setURI(uri);
		spread.setName(name);;
		spread.setFirstIDATName(element.getAttribute("firstIDATName"));
		spread.setSecondIDATName(element.getAttribute("secondIDATName"));
		spread.setThirdIDATName(element.getAttribute("thirdIDATName"));
	
		NodeList nodes = element.getChildNodes();
		for(int i=0;i<nodes.getLength();i++){
			if(nodes.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)nodes.item(i);
				String tagname = elem.getNodeName();
				if(tagname.equals("region")){
					Region region = XML2ResourceConverter.getRegion(spread, elem);
					spread.addRegion(region);
				}else if(tagname.equals("spreadDocument")){
					IDAT iDAT = getIDAT(spread,elem);
//					iDAT.setSpread(spread);
					if(iDAT.getType() == GSConstants.SECONDIDAT){
						spread.setSecondIDAT((SecondIDAT)iDAT);
					}else if(iDAT.getType() == GSConstants.FIRSTIDAT){
						spread.setFirstIDAT((FirstIDAT)iDAT);
					}else if(iDAT.getType() == GSConstants.THIRDIDAT){
						spread.setThirdIDAT((ThirdIDAT)iDAT);
					}
				}
			}
		}
		debug2(spread.uri,spread.originalURI);
		return spread;
	}
	public static TextSegment getTextSegment(Element element, boolean dummy){
		String tagname = element.getAttribute("tagname");
		String id = element.getAttribute(GSResource.ID);
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		//debug
		debug1("getTextSegment(element)",uri,originalURI);
		TextSegment segment = new TextSegment(tagname,new Integer(id),uri,originalURI);
		debug2(segment.uri,segment.originalURI);
		return segment;
	}
	
	private static StandardTextDocument getStandardDocument(Element element){
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		//debug
		debug1("getStandardDocument(element)",uri,originalURI);
		String name = element.getAttribute(GSResource.NAME);
		String source = element.getAttribute("source");
		NodeList list = element.getElementsByTagName("segment");
		StandardTextDocument doc = new StandardTextDocument(source,name,uri,originalURI);
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			doc.addTextSegment(segment);
			segment.setSmartDocument(doc);
		}
		debug2(doc.uri,doc.originalURI);
		return doc;
		
	}
	

	public static UsersNote getUsersNote(Element element){
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		//debug
		debug1("getUsersNote(element)",uri,originalURI);
		String name = element.getAttribute(GSResource.NAME);
		String source = element.getAttribute("source");
		if(!source.startsWith("<xml><html>")){
			try{
				ConvertGS convertGS = new ConvertGS(source);
				source = convertGS.parser();
				if(source.equals("")){
					source = "<xml><html></html></xml>";
				}else{
					source = "<xml><html>" + source + "</html></xml>";
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		NodeList list = element.getElementsByTagName("segment");
		UsersNote usersNote = new UsersNote();
//		shayashi ask Kukita
//		usersNote.setURI(uri);
//		UserNote(uri,orinalURI)H
		usersNote.setSource(source);
		usersNote.setURIs(uri, originalURI);
		for(int i=0;i<list.getLength();i++){
			TextSegment segment = TextSegment.restore((Element)list.item(i));
			usersNote.addTextSegment(segment);
			segment.setSmartDocument(usersNote);
		}
		debug2(usersNote.uri,usersNote.originalURI);
		return usersNote;
	}

	// for debug
	private static void debug1(String methodName, String uri, String originalURI) {
		System.out.println("debug print from XML2ResourceConverter, " + methodName);
		System.out.println("  attribute uri: " + uri);
		System.out.println("  attribute originalURI: " + originalURI);

	}
	private static void debug2(String uri, String originalURI) {
		System.out.println("  restored uri: " + uri);
		System.out.println("  restored originalURI: " + originalURI);

	}
}
