/* $Id: StandardTextDocument.java 162 2011-05-15 15:37:47Z shayashi $ */
package smart_gs.logical;

import smart_gs.GSConstants;
import smart_gs.logical.visitor.Visitor;


public class StandardTextDocument extends SmartDocument{
	
	
	public StandardTextDocument(String uri, String originalURI) {
		super();
		this.setURIs(uri, originalURI);
	}
	public StandardTextDocument(String source,String name, String uri,String originalURI){
		super(source);
		this.name = name;
		this.setURIs(uri, originalURI);
	}
	
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.STANDARD_TEXT_DOCUMENT;
	}
}
