/* $Id: LineSegment.java 162 2011-05-15 15:37:47Z shayashi $ */
package smart_gs.logical;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.awt.Polygon;

import smart_gs.drawing_tool.ExLine2D;
import smart_gs.drawing_tool.view.LineSegmentView;
import smart_gs.drawing_tool.view.View;



/**
 * 
 * @author kazuaki kobayashi
 *
 * Spread̍s\NX
 */
public class LineSegment extends Region{

	
	
	public LineSegment(Spread spread,List<Point2D> points, 
			String uri, String originalURI){
		super(spread, URICreator.LINE_SEGMENT);
		this.points = points;
		this.createView();
		this.setURIs(uri, originalURI);
	}
	
	private void createView(){
		List<ExLine2D> lines = new ArrayList<ExLine2D>();
		for(int i=0;i<this.points.size()-1;i++){
			Point2D start = this.points.get(i);
			Point2D end = this.points.get(i+1);
			ExLine2D line = new ExLine2D(start,end);
			lines.add(line);
		}
		this.view = new LineSegmentView(lines);
	}
	public Spread getSpread() {
		return this.spread;
	}
	public List<Point2D> getPoints() {
		return this.points;
	}
	public View getView(){
		return this.view;
	}
	
	//20110221 shimizu add
	public void changeSize(double m){
	  List<Point2D> points = this.getPoints();
	  for(int i=0;i<points.size();i++){
		  Point2D point = points.get(i);
		  double x = point.getX()*m;
		  double y = point.getY()*m;
		  point.setLocation(x,y);
	  }
	  this.createView();
	}
	
	public void slideLine(double x1, double y1){
		List<Point2D> points = this.getPoints();
		for(int i=0;i<points.size();i++){
			Point2D point = points.get(i);
			double x = point.getX() + x1;
			double y = point.getY() + y1;
			point.setLocation(x,y);
		}
		this.createView();
	}
	//20100825 shimizu add
	public Polygon getPolygon(){
		Polygon polygon = new Polygon();
		for(int i=0; i<this.points.size()-1;i++){
			int x = (int)this.points.get(i).getX();
			int y = (int)this.points.get(i).getY();
			polygon.addPoint(x, y);
		}
		return polygon;
	}
	//20101110 shimizu wrote;
	public void addPoint(Point2D point){
		List<ExLine2D> lines = new ArrayList<ExLine2D>();
		for(int i=0;i<this.points.size()-1;i++){
			Point2D start = this.points.get(i);
			Point2D end = this.points.get(i+1);
			ExLine2D line = new ExLine2D(start,end);
			lines.add(line);
		}
	    double dist = lines.get(0).ptLineDist(point);
	    int x = 0;
		for(int i=1;i<lines.size();i++){
			Double d = lines.get(i).ptLineDist(point);
			if(d<dist){
				dist = d;
				x = i;
			}
			
		}
		this.points.add(x+1,point);
		this.createView();
	}
}
