/* $Id: SearchResultViewer.java 162 2011-05-15 15:37:47Z shayashi $ */
package smart_gs.image_search.normal.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JLabel;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBacket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.desktop.swingui.DesktopWindow;

@SuppressWarnings("serial")
public class SearchResultViewer extends JFrame{
	
	
	private List<SearchResult> results;
	private List<SearchResult> newResults;
	private AbstractSearchResultPanel resultPanel;
	private JScrollPane scrollPane;
	private GSQuery query;
	// 20110423 shayashi
	private Image queryImage;
	private QueryBacket backet;
	protected List<SearchResult> selectedResults;
	private JPanel mainPanel;
	
	/*
	 * 20071109 c
	 * 폜ꂽ̃Xgǉ
	 */
	protected List<SearchResult> removedResults;
	BacketFrame backetFrame;
	
	private static int pSize;
	
	//y[W̕\
	private JLabel searchedPageLabel;
	private String searchedPage;
	
	public SearchResultViewer(QueryBacket backet,List<SearchResult> results){
		super("Search Result");
		this.backet = backet;
		this.results = results;
		 // 20071110 c
		this.removedResults = new ArrayList<SearchResult>();
		pSize = backet.size();
		/*
		 * VȌʂ
		 */
		this.newResults = new ArrayList<SearchResult>();
		for (int i = 0; i < results.size(); i++) {
		    if (!results.get(i).wasShown()) {
			newResults.add(results.get(i));
		    }
		}
		
		this.query = this.backet.get(0);
		this.selectedResults = new ArrayList<SearchResult>();
		
		this.checkDuplicate();
		
		this.queryImage = this.query.getQueryImage();
		this.build(queryImage);
		
		QueryBacket qb = new QueryBacket("","",false);
		
		int size = this.backet.size();
		for(int i=0;i<this.backet.size();i++){
			qb.add(this.backet.get(i));
		}
		DesktopWindow.getInstance().addQueryHistory(qb);
		
		//20071109 c
		backetFrame = new BacketFrame(this.backet,"Backet",this.results, removedResults, size);
		backetFrame.pack();
		
		
		this.setSize(1000,730);
		backetFrame.setVisible(true);
	}
	//2007/10/11 kazuhiro kobayashi 
	//Ώۂ̃y[W\RXgN^
	public SearchResultViewer(QueryBacket backet,List<SearchResult> results, String searchedPage){
		this(backet, results);
		this.searchedPage = searchedPage;
		
	}
	/*
	 * 20071121 c
	 * ̌̃oPbg̃TCY𓾂
	 */ 
	public int getPreviousBacketSize() {
	    return pSize;
	}
	public List<SearchResult> getResults() {
		return results;
	}
	public List<SearchResult> getNewResults() {
	    return newResults;
	}
	
	// 20071109 c
	public List<SearchResult> getRemovedResults() {
	    return removedResults;
	}
	
	public void setResultPanel(AbstractSearchResultPanel resultPanel) {
		if(this.resultPanel instanceof SearchResultPanelSegmentMode){
			mainPanel.remove(this.resultPanel);
		}else{
			mainPanel.remove(this.scrollPane);
		}
		this.resultPanel = resultPanel;

		if(this.resultPanel instanceof SearchResultPanelSegmentMode){
			mainPanel.add(this.resultPanel,BorderLayout.CENTER);
		}else{
			this.scrollPane.setViewportView(resultPanel);
			mainPanel.add(this.scrollPane,BorderLayout.CENTER);
		}
	}
	private void checkDuplicate(){
		for(int i=0;i<this.backet.size();i++){
			Rectangle rect = this.backet.get(i).getRectangle();
			Spread spread = this.backet.get(i).getSpread();
			Point2D center = new Point2D.Double(rect.getCenterX(),rect.getCenterY());
			if(spread == null){
				continue;
			}
			for(int j=0;j<this.results.size();j++){
				Rectangle rect2 = this.results.get(j).getRectangle();
				Spread spread2 = this.results.get(j).getSpread();
				if(spread.equals(spread2) && rect2.contains(center)){
					this.results.get(j).setIsInBacket(true);
				}
			}
		}
	}
	public List<SearchResult> getSelectedResults() {
		return this.selectedResults;
	}
	public QueryBacket getBacket(){
		return this.backet;
	}
	private void build(Image queryImage){

		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		JPanel queryPanel = new QueryPanel(queryImage);
		
		this.scrollPane = new JScrollPane();
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
//		this.resultPanel = new SearchResultPanel(this,this.results);
//		this.resultPanel = new SearchResultPanelContextMode(this,this.results);
		this.resultPanel = new SearchResultPanelSegmentMode(this,this.results,queryImage);
		
		this.scrollPane.setViewportView(this.resultPanel);
		
		mainPanel = new JPanel();
		
		JPanel buttonPanel = new JPanel();
		JButton back = new JButton("back");
		back.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultPanel.back();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});
		JButton next = new JButton("next");
		next.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				resultPanel.next();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});

		buttonPanel.add(back);
		buttonPanel.add(next);
		
		mainPanel.setLayout(new BorderLayout());
		//2007/10/15 kazuhiro kobayashi y[W\邽
//		mainPanel.add(queryPanel,BorderLayout.NORTH);
		/*
		 * y[W̕\
		 */
		JPanel topPanel = new JPanel();
		this.searchedPageLabel = new JLabel("search scope: "+this.searchedPage);
		topPanel.add(searchedPageLabel);
		topPanel.add(queryPanel);
		mainPanel.add(topPanel, BorderLayout.NORTH);
		
//		mainPanel.add(searchedPageLabel, BorderLayout.NORTH);
		//
		
		if(this.resultPanel instanceof SearchResultPanelSegmentMode){
			mainPanel.add(this.resultPanel,BorderLayout.CENTER);
		}else{
			mainPanel.add(this.scrollPane,BorderLayout.CENTER);
		}
		
		
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		
		JPanel northPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		northPanel.add(new SearchMenuBar(this));
		
		this.getContentPane().add(northPanel,BorderLayout.NORTH);

		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		this.pack();
	}
	
//	public void updateBacket(){
//		GSQuery lastQuery = this.backet.get(this.backet.size()-1);
//		Rectangle rect = lastQuery.getRectangle();
//		Spread spread = lastQuery.getSpread();
//		Point2D center = new Point2D.Double(rect.getCenterX(),rect.getCenterY());
//		for(int j=0;j<this.results.size();j++){
//			Rectangle rect2 = this.results.get(j).getRectangle();
//			Spread spread2 = this.results.get(j).getSpread();
//			if(spread.equals(spread2) && rect2.contains(center)){
//				this.results.get(j).setIsInBacket(true);
//			}
//		}
//		this.resultPanel.updateBacket();
//	}
	//ύX@c
	public void updateBacket(boolean deleting) {
	    if (deleting) {
		this.removeBacket();
	    } else {
		this.addBacket();
	    }
	}
	
	private void removeBacket() {
	    // TODO Auto-generated method stub
	    GSQuery lastQuery = this.backet.get(this.backet.size() - 1);
	    Rectangle rect = lastQuery.getRectangle();
	    Spread spread = lastQuery.getSpread();
	    Point2D center = new Point2D.Double(rect.getCenterX(), rect.getCenterY());
	    for (int j = 0; j < this.results.size(); j++){
		Rectangle rect2 = this.results.get(j).getRectangle();
		Spread spread2 = this.results.get(j).getSpread();
		if (spread.equals(spread2) && rect2.contains(center)){
		    this.results.get(j).setIsInBacket(false);
		}
	    }
	    this.resultPanel.updateBacket();
	}

	public void addBacket(){
		GSQuery lastQuery = this.backet.get(this.backet.size()-1);
		Rectangle rect = lastQuery.getRectangle();
		Spread spread = lastQuery.getSpread();
		Point2D center = new Point2D.Double(rect.getCenterX(),rect.getCenterY());
		for(int j=0;j<this.results.size();j++){
			Rectangle rect2 = this.results.get(j).getRectangle();
			Spread spread2 = this.results.get(j).getSpread();
			if(spread.equals(spread2) && rect2.contains(center)){
				this.results.get(j).setIsInBacket(true);
			}
		}
		this.resultPanel.updateBacket();
	}
	// 20071109 c -- 폜̍XV
	public void updateRemoved() {
	   this.backetFrame.setRemovedResults(this.removedResults);
	}
	// 20110423 shayashi
	public Image getQueryImage() {
		return queryImage;
	}
}
