/* $Id: BacketPanel.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.GridLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBacket;

@SuppressWarnings("serial")
public class BacketPanel extends JPanel implements Observer{
	
	private QueryBacket backet;
	private JFrame parent;
	
	public BacketPanel(JFrame parent,QueryBacket backet){
		this.parent = parent;
		this.backet = backet;
		this.backet.addObserver(this);
		this.updateGUI();
	}
	
	public void updateGUI(){
		this.removeAll();
		this.setLayout(new GridLayout(this.backet.size(),1));
		for(int i=0;i<this.backet.size();i++){
			GSQuery query = this.backet.get(i);
			JLabel label = new JLabel(new ImageIcon(query.getQueryImage()));
			label.addMouseListener(new ShowQueryAction(query));
			//JPanel panel = new JPanel(new BorderLayout());
			JPanel panel = new JPanel();
			panel.setBorder(new LineBorder(Color.BLACK));
//			panel.add(new JCheckBox());
			panel.add(label);
			JButton editButton = new JButton("edit");
			editButton.addActionListener(new EditAction(this,query));
			panel.add(editButton);
//			panel.add(label,BorderLayout.CENTER);
			this.add(panel);
		}
		this.parent.validate();
		this.parent.toFront();
		this.parent.pack();
	}

	public void update() {
		this.updateGUI();
		
	}
	public QueryBacket getBacket() {
		return this.backet;
	}
}
