/* $Id: MarkerMode.java 162 2011-05-15 15:37:47Z shayashi $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;


import smart_gs.drawing_tool.SpreadCanvas;
//import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.logical.region.MarkerRegion;
import smart_gs.swingui.GSMouseEvent;

public class MarkerMode extends DrawingModeAdapter{
	
	private static Mode singleton = new MarkerMode();
	
	private Point2D start;
	private Point2D end;
	
	private Point2D tempStart;
	private Point2D tempEnd;
	
	public static Mode getInstance(){
		return singleton;
	}
	
	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		super.mousePressed(e, canvas);
		this.start = e.getPoint();
		this.tempStart = e.getOriginalPoint();
	}
	@Override
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
		this.tempEnd = e.getOriginalPoint();
	}
	
	@Override
	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		super.mouseReleased(e, canvas);
		if(start == null || end == null){
			return ;
		}
		canvas.addRegion(new MarkerRegion(canvas.getSpread(),start,end,"",""));
		this.start = null;
		this.end = null;
		this.tempStart = null;
		this.tempEnd = null;
//		DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
	}
	@Override
	public void paint(Graphics g,SpreadCanvas canvas) {
		super.paint(g,canvas);
		if(this.tempStart == null || this.tempEnd == null){
			return;
		}
		new MarkerView(tempStart,tempEnd).draw((Graphics2D)g);
//		if(this.start == null || this.end == null){
//			return;
//		}
//		double ratio = canvas.getImageLabel().getRatio();
//		new MarkerView(start,end).enlargedView(ratio).draw((Graphics2D)g);
	}
	
}
