/* $Id: SearchResultDictionaryViewer.java 162 2011-05-15 15:37:47Z shayashi $ */
package smart_gs.dictionary.viewer;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

import smart_gs.drawing_tool.view.RectangleView;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBacket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.desktop.swingui.DesktopWindow;

@SuppressWarnings("serial")
public class SearchResultDictionaryViewer extends JFrame{
	
	
	private List<SearchResult> results;
	private List<SearchResult> newResults;
	private AbstractSearchResultPanel resultPanel;
	private JScrollPane scrollPane;
	private GSQuery query;
	
	private QueryBacket backet;
	protected List<SearchResult> selectedResults;
	private JPanel mainPanel;
	
	private static int pSize;
	
	//y[W̕\
	private JLabel searchedPageLabel;
	private String searchedPage;
	
	public SearchResultDictionaryViewer(QueryBacket backet,List<SearchResult> results){
		super("Search Result");
		this.backet = backet;
		this.results = results;
		pSize = backet.size();
		/*
		 * VȌʂ
		 */
		this.newResults = new ArrayList<SearchResult>();
		for (int i = 0; i < results.size(); i++) {
		    if (!results.get(i).wasShown()) {
			newResults.add(results.get(i));
		    }
		}
		
		this.query = this.backet.get(0);
		this.selectedResults = new ArrayList<SearchResult>();
		
		// this.checkDuplicate();
		

		Region region = new Region(this.query.getSpread(),new RectangleView(this.query.getRectangle()),"","");
		this.build(this.query.getQueryImage(),region);
		
		QueryBacket qb = new QueryBacket("", "",false);
		
		int size = this.backet.size();
		for(int i=0;i<this.backet.size();i++){
			qb.add(this.backet.get(i));
		}
		DesktopWindow.getInstance().addQueryHistory(qb);
		
		int xresize = 730;
		switch (results.size()) {
			case 0:
				xresize = 350;
			break;
			case 1:
				xresize = 450;
			break;
			case 2:
				xresize = 550;
			break;
			case 3:
				xresize = 650;
			break;
			default:
				xresize = 750;
			break;
		}
		int resultsize = results.size();
		int yresize = 250;
		if(yresize != 0){
			int linesize = (int)Math.ceil((double)((double)resultsize/(double)4));
			switch (linesize) {
			case 0:
				yresize = 250;
			break;
			case 1:
				yresize = 300;
			break;
			case 2:
				yresize = 380;
			break;
			case 3:
				yresize = 450;
			break;
			case 4:
				yresize = 530;
			break;
			default:
				yresize = 600;
			break;
		}
		}
		
		this.setSize(xresize,yresize);
//		this.setSize(1000,730);
	}
	//2007/10/11 kazuhiro kobayashi 
	//Ώۂ̃y[W\RXgN^
	public SearchResultDictionaryViewer(QueryBacket backet,List<SearchResult> results, String searchedPage){
		this(backet, results);
		this.searchedPage = searchedPage;
		
	}
	/*
	 * 20071121 c
	 * ̌̃oPbg̃TCY𓾂
	 */ 
	public int getPreviousBacketSize() {
	    return pSize;
	}
	public List<SearchResult> getResults() {
		return results;
	}
	public List<SearchResult> getNewResults() {
	    return newResults;
	}
	
	
	public List<SearchResult> getSelectedResults() {
		return this.selectedResults;
	}
	public QueryBacket getBacket(){
		return this.backet;
	}
	private void build(Image image,Region region){

		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		JPanel queryPanel = new QueryPanel(image);
		
		this.scrollPane = new JScrollPane();
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		this.resultPanel = new SearchResultListPanel(this,this.results,region,20);
		
		this.scrollPane.setViewportView(this.resultPanel);
		
		mainPanel = new JPanel();
		
		JPanel buttonPanel = new JPanel();
		JButton back = new JButton("back");
		back.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				resultPanel.back();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});
		JButton next = new JButton("next");
		next.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent arg0) {
				resultPanel.next();
				scrollPane.getVerticalScrollBar().setValue(0);
				validate();
			}
		});

		buttonPanel.add(back);
		buttonPanel.add(next);
		
		mainPanel.setLayout(new BorderLayout());
		//2007/10/15 kazuhiro kobayashi y[W\邽
//		mainPanel.add(queryPanel,BorderLayout.NORTH);
		/*
		 * y[W̕\
		 */
		JPanel topPanel = new JPanel();
		this.searchedPageLabel = new JLabel("search scope: "+this.searchedPage);
		topPanel.add(searchedPageLabel);
		topPanel.add(queryPanel);
		mainPanel.add(topPanel, BorderLayout.NORTH);
		
//		mainPanel.add(searchedPageLabel, BorderLayout.NORTH);
		//
		
		if(this.resultPanel instanceof SearchResultListPanel){
			JScrollPane scrollpane = new JScrollPane(this.resultPanel);
			scrollpane.setBorder(new EmptyBorder(2,2,2,2));
//			mainPanel.add(this.resultPanel,BorderLayout.CENTER);
//			mainPanel.add(scrollpane,BorderLayout.CENTER);
			mainPanel.add(this.resultPanel,BorderLayout.CENTER);
		}else{
			mainPanel.add(this.scrollPane,BorderLayout.CENTER);
		}
		
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		

		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		this.pack();
	}
}
