/* $Id: RWRepository.java 162 2011-05-15 15:37:47Z shayashi $ */
/*
 * 쐬: 2006/06/02
 *
 */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.reasoning_web.logical.GS_RWElement;


/**
 * @author kazuaki kobayashi
 * 
*/
public class RWRepository {
	
	protected List<Connection> connections;
	
	protected List<ResourcePointer> pointers;
	
	private Factory factory;
	
	private List<Observer> observers;
	
	
	protected RWRepository(){
		this.factory = this.getFactory();
		this.connections = new ArrayList<Connection>();
		this.pointers = new ArrayList<ResourcePointer>();
		this.observers = new ArrayList<Observer>();
	}
	public void initialize(){
		this.connections.clear();
		this.pointers.clear();
	}
	protected Factory getFactory() {
		return new DefaultFactory();
	}
	/**
	 * elementɑΉResourcePointerԂ
	 * @param element
	 * @return
	 */
	public ResourcePointer getResourcePointer(RWElement element){
		for(int i=0;i<this.pointers.size();i++){
			if(this.pointers.get(i).getElement().equals(element)){
				return this.pointers.get(i);
			}
		}
		return null;
	}
	
	public boolean isRegistered(RWElement element){
		for(int i=0;i<this.pointers.size();i++){
			if(this.pointers.get(i).getElement().equals(element)){
				return true;
			}
		}
		return false;
	}
	/**
	 * sourcetargetԂconnection쐬B
	 * note͂connecitonɕt
	 * 
	 * @param source
	 * @param target
	 * @param note
	 */
	public void createConnection(RWElement source,RWElement target,
			ExplanatoryNote note,int dependency, String uri, String originalURI, boolean restored){
		ResourcePointer sourcePointer;
		if(!this.isRegistered(source)){
			sourcePointer = factory.createResourcePointer(source);
			this.register(sourcePointer);
		}else{
			sourcePointer = this.getResourcePointer(source);
		}
		
		ResourcePointer targetPointer;
		if(!this.isRegistered(target)){
			targetPointer = this.factory.createResourcePointer(target);
			this.register(targetPointer);
		}else{
			targetPointer = this.getResourcePointer(target);
		}
		this.addConnection(sourcePointer, targetPointer, note,dependency,uri,originalURI,restored);
		
		new ERCalculator().calculate();
	}
	protected void register(ResourcePointer pointer){
		if(!this.pointers.contains(pointer)){
			this.pointers.add(pointer);
		}
		this.notifyChange();
	}
	/**
	 * sourcetargetԂconnection쐬B
	 * note͂connecitonɕt
	 * 
	 * @param source
	 * @param target
	 * @param note
	 */
	private void addConnection(ResourcePointer source,ResourcePointer target,
			ExplanatoryNote note,int dependency, String uri, String originalURI, boolean restored){
		this.connections.add(this.factory.createConnection(source, target, note,dependency, uri, originalURI));
	}
	protected void addConnection(Connection connection){
		this.connections.add(connection);
	}
	/**
	 * elementŎw肳ꂽResourceReasoning Webɓo^
	 * @param element
	 */
	public void register(RWElement element){
		ResourcePointer pointer = this.factory.createResourcePointer(element);
		this.pointers.add(pointer);
		this.notifyChange();
	}
	/**
	 * elementŎw肳ꂽresourceNׂ
	 * @param element
	 * @return 
	 */
	public boolean hasLink(RWElement element){
		ResourcePointer pointer = this.getResourcePointer(element);
		if(pointer == null){
			return false;
		}
		return pointer.hasLink();
	}
	/**
	 * ׂĂconnectionԂ
	 * @return
	 */
	public List<Connection> getConnections(){
		return this.connections;
	}
	/**
	 * ݓo^Ă邷ׂĂResourcePointerԂ
	 * @return
	 */
	public List<ResourcePointer> getResourcePointers(){
		return this.pointers;
	}
	
	public List<RWElement> getDirectElements(ResourcePointer pointer){
		if(pointer == null){
			return null;
		}
		return pointer.getDirectLinkElements();
	}
	public void addObserver(Observer observer){
		this.observers.add(observer);
	}
	public void notifyChange(){
		for(int i=0;i<this.observers.size();i++){
			this.observers.get(i).update();
		}
	}		
	
	
	
}
