/* $Id: RWPackage.java 162 2011-05-15 15:37:47Z shayashi $ */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.List;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.logical.URICreator;
import smart_gs.reasoning_web.URIBearer;

public class RWPackage implements RWElement,URIBearer {
	
	protected List<RWElement> elements;
	protected String name ="";
	protected String source = "<xml></xml>";
	protected String uri;
	protected String originalURI;
	protected String oldVersionURI;
	
	public RWPackage(String uri, String originalURI, boolean restored){
		this.elements = new ArrayList<RWElement>();
		this.setURIs(uri, originalURI);
	}
	public void setName(String name){
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void add(RWElement element){
		this.elements.add(element);
	}
	public void add(List<RWElement> elements){
		this.elements.addAll(elements);
	}

	public List<RWElement> getElements(){
		return this.elements;
	}


	public String getSource() throws NotMarkupException {
		return source;
	}
	public void setSource(String source) {
		this.source = source;
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getURI() {
		return this.uri;
	}
	@Override
	public String getTypeString() {
		return URICreator.RWPACKAGE;
	}
	@Override
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
		
	}
	@Override
	public void setURI(String uri) {
		this.uri = uri;
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}
	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}
	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;		
	}

}
