/* $Id: ChangeImpactAnalysis2.java 125 2011-03-09 09:49:51Z ohura $ */
package reasoning_web.logical;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import smart_gs.reasoning_web.logical.GS_RWRepository;


public class ChangeImpactAnalysis2 extends AbstractCIAnalysis{

	public ChangeImpactAnalysis2(ResourcePointer changeSource) {
		super(changeSource);
	}
	
	private void analyze(ResourcePointer pointer,Hashtable<ResourcePointer,Double> table,List<ResourcePointer> stack,int distance){
//		List<ResourcePointer> pointers = pointer.getBackwardDependentElements();
		List<ResourcePointer> pointers = pointer.getDependentElements();
		double f = 1.0/Math.log(distance+Math.E);
//		double ci = pointer.getElementRank()*f;
		double ci = 0.0;
		stack.add(pointer);
		for(int i=0;i<pointers.size();i++){
			ResourcePointer element = pointers.get(i);
			if(!stack.contains(element)){
				if(table.containsKey(element)){     //łɌvZς݂̏ꍇ
					ci += (table.get(element)*f*element.getElementRank());
				}else{
					this.analyze(element,table,stack,distance-1);
					ci += (table.get(element)*f*element.getElementRank());
				}
			}
		}
		stack.remove(pointer);
		table.put(pointer, ci);
	}
	
	@Override
	public void execute() {
		this.table.clear();
		List<ResourcePointer> pointers = GS_RWRepository.getInstance().getResourcePointers();
//		List<ResourcePointer> pointers = this.changeSource.getBackwardDependentElements();
		
		List<ResourcePointer> stack = new ArrayList<ResourcePointer>();
		
		this.table.put(this.changeSource,this.changeSource.getElementRank());
		
		for(int i=0;i<pointers.size();i++){
			if(!this.table.containsKey(pointers.get(i))){
				this.analyze(pointers.get(i),table,stack,1);
			}
		}
	}
	
	
	
}
