/* $Id: AbstractCIAnalysis.java 125 2011-03-09 09:49:51Z ohura $ */
package reasoning_web.logical;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;

import smart_gs.reasoning_web.swingui.CISortComperator;

public abstract class AbstractCIAnalysis {
	
	protected ResourcePointer changeSource;
	
	/**
	 * CI͂̌ʂ^table
	 */
	protected Hashtable<ResourcePointer,Double> table;   
	
	
	public AbstractCIAnalysis(ResourcePointer changeSource){
		this.changeSource = changeSource;
		this.table = new Hashtable<ResourcePointer,Double>();
	}
	
	public abstract void execute();
	
	@SuppressWarnings("unchecked")
	protected Object[] sortTable(Hashtable<ResourcePointer, Double> table) {
		Object[] keys = table.keySet().toArray();
		Arrays.sort(keys,new CISortComperator(table));		
		return keys;
	}
	



	protected double getMinValue(){
		Iterator<Double> values = table.values().iterator();
		
		double minValue = -1.0;
		if(!values.hasNext()){
			minValue = values.next();
		}
		while(values.hasNext()){
			double value = values.next();
			if(minValue > value){
				minValue = value;
			}
		}
		return minValue;
	}
	protected double getMaxValue(){
		Iterator<Double> values = table.values().iterator();
		
		double maxValue = -1.0;
		if(!values.hasNext()){
			maxValue = values.next();
		}
		while(values.hasNext()){
			double value = values.next();
			if(maxValue < value){
				maxValue = value;
			}
		}
		return maxValue;
	}
	

	public ResourcePointer getChangeSource() {
		return changeSource;
	}
	public void setChangeSource(ResourcePointer changeSource) {
		this.changeSource = changeSource;
	}
	
}
