/* $Id: DrawPointCommand.java 125 2011-03-09 09:49:51Z ohura $ */
package image_editor.toolbar;

import java.awt.Color;
import java.awt.Graphics;
public class DrawPointCommand implements DrawCommand{
	
	private int x;
	private int y;
	private static  int WIDTH = 2;
	private static  int HEIGHT = 2;
	private Color color;
	
	
	public DrawPointCommand(int x,int y){
		this.x = x;
		this.y = y;
		this.color = Color.black;
	}

	public void execute(Graphics g) {
		Color oldColor = g.getColor();
		g.setColor(this.color);
		g.fillRect(x,y,WIDTH,HEIGHT);
		g.setColor(oldColor);
	}
	public void setColor(Color color){
		this.color = color;
	}
	
	
}
