/* $Id: EraserMode.java 125 2011-03-09 09:49:51Z ohura $ */
package image_editor;

import image_editor.toolbar.EraseCommand;

import java.awt.event.MouseEvent;


public class EraserMode extends Mode {
	//kazuhiro kobayashi 10/2
	private int lastX, lastY;
	private int currentX, currentY;
	private static float WIDTH;
	
	private static EraserMode singleton = new EraserMode();
	
	public static Mode getInstance(){
		return singleton;
	}
	
	
	//kazuhiro kobayashi 10/2
	public static void setWidth(float width){
		WIDTH = width;
	}
	
	@Override
	public void mouseClicked(MouseEvent e, EditorCanvas canvas) {
		//kazuhiro kobayashi 10/2
		currentX = e.getX();
		currentY = e.getY();
		lastX = e.getX();
		lastY = e.getY();
	}

	@Override
	public void mouseDragged(MouseEvent e, EditorCanvas canvas) {
//		canvas.addCommand(new EraseCommand(e.getX(),e.getY()));
		currentX = e.getX();
		currentY = e.getY();
		EraseCommand eraseCommand = new EraseCommand(lastX, lastY, currentX,
				currentY);
		eraseCommand.setWidth(WIDTH);
		canvas.addCommand(eraseCommand);
		lastX = currentX;
		lastY = currentY;
	}

	@Override
	public void mouseEntered(MouseEvent e, EditorCanvas canvas) {

	}

	@Override
	public void mouseExited(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mouseMoved(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mousePressed(MouseEvent e, EditorCanvas canvas) {
		//kazuhiro kobayashi 10/2
//		canvas.addCommand(new EraseCommand(e.getX(),e.getY()));
		currentX = e.getX();
		currentY = e.getY();
		lastX = e.getX();
		lastY = e.getY();
	}

	@Override
	public void mouseReleased(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

}
