package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.JSplitPane;

import smart_gs.logical.SpreadDocument;

@SuppressWarnings("serial")
public class SpreadDocumentPanel extends JPanel{
	
	protected SpreadDocument document;
	private GSEditorTextPane leftTextPane;
	private GSEditorTextPane rightTextPane;
	
	public SpreadDocumentPanel(){
		super();
	}
	
	public SpreadDocumentPanel(GSEditorFrame parent,SpreadDocument document){
		this.document = document;
		String leftSource = this.document.getLeftPageSource();
		String rightSource = this.document.getRightPageSource();

		leftSource = getInitSource(leftSource);
		ArrayList taglist = new ArrayList();
		try{
			LoadTagNameParser loadTagNameParser = new LoadTagNameParser(leftSource);
			taglist = loadTagNameParser.parser();
		}catch(Exception e){
			e.printStackTrace();
		}
		this.leftTextPane = new GSEditorTextPane(document,leftSource,GSEditorTextPane.LEFT);
		for(int i=0;i<taglist.size();i++){
			this.leftTextPane.getGSHTMLEditorTextPane().addTagList((String)taglist.get(i));
		}
//		this.rightTextPane = new GSEditorTextPane(document,null,GSEditorTextPane.RIGHT);
		new GSEditorPanel(parent,this.leftTextPane);
//		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,new GSEditorPanel(parent,this.leftTextPane),new GSEditorPanel(parent,this.rightTextPane));
//		splitPane.setDividerLocation(500);
		this.setLayout(new BorderLayout());
//		this.add(splitPane,BorderLayout.CENTER);
/*		JScrollPane spanel =new JScrollPane(leftTextPane);
		spanel.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		this.add(spanel,BorderLayout.CENTER); */
		this.add(leftTextPane,BorderLayout.CENTER);
	}
	public void save(){
		this.leftTextPane.save();
//		this.rightTextPane.save();
	}
	public void emphasize(String id) {
		this.leftTextPane.emphasize(id);
//		this.leftTextPane.getGSHTMLEditorTextPane().emphasize(id);
//		this.rightTextPane.getGSHTMLEditorTextPane().emphasize(id);
	}
	public void updateText() {
		this.leftTextPane.getGSHTMLEditorTextPane().updateText();
//		this.rightTextPane.getGSHTMLEditorTextPane().updateText();
	}

	public GSEditorTextPane getleftTextPane(){
		return this.leftTextPane;
	}
	public GSEditorTextPane getrightTextPane(){
		return this.rightTextPane;
	}

	public void jumpLinkToText(int position){
		FocusEvent aEvent = new FocusEvent(leftTextPane.getGSHTMLEditorTextPane(), FocusEvent.FOCUS_GAINED);
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(aEvent);
		if(position == 0){
			this.leftTextPane.setCaretPosition(1);
			return;
		}
		String text = leftTextPane.getPainText();
		if(text != null){
			if(!text.equals("")){
				int jumpposition = 1;
				int jumpcounter = 0;
				for(int i=0;i<text.length();i++){
					if(position == jumpcounter){
						this.leftTextPane.setCaretPosition(jumpposition);
						return;
					}
					if(text.charAt(i) == '\n'){
						jumpcounter++;
						jumpposition++;
					}else if(text.charAt(i) == '\r'){
					}else{
						jumpposition++;
					}
				}
			}
		}
	}
	public SpreadDocument getSpreadDocument(){
		return document;
	}
	
	protected String getInitSource(String sourceStr){
		String source = sourceStr;
		boolean leftload = false;

		if(source == null){
			return source;
		}
		try{
			if(source.startsWith("<xml><left><html>")){
				if(source.endsWith("</html></left></xml>")){
					source = source.substring("<xml><left><html>".length(),source.length() - "<body></left></html>".length());
					leftload =  true;
				}
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		if(!leftload){
			source = null;
		}
		return source;
		
	}
	
}
