package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import smart_gs.logical.SmartDocument;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorFrame;

@SuppressWarnings("serial")
public class GSTreeTextEditor extends JFrame implements EditorFrame{
	
	private SmartDocument document;
	
//	private GSTabbedPane tabbedPane;
	private JToolBar toolBar;
	private GSEditorTextPane textPane;

	public GSTreeTextEditor(SmartDocument document, String name){
		super(name);

		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		this.document = document;
		String xml = this.document.getSource();
		String source = null;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		this.textPane = new GSEditorTextPane(this.document,source,GSEditorTextPane.BASIC);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
//		this.tabbedPane = new GSTabbedPane(document,this);
		
		JPanel toolBarPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		
	//	GSEditorTextPane textPane = this.tabbedPane.getTextPane();
		this.toolBar = new GSEditorToolBar(textPane);
		toolBarPanel.add(this.toolBar);
		
		this.getContentPane().add(toolBarPanel,BorderLayout.NORTH);
		this.getContentPane().add(this.textPane,BorderLayout.CENTER);

		//2008/9/19 North Grid
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				ok();
			}
		});
		
		this.setSize(800,600);
		this.validate();
	}
	
	public void ok() {
		String source = textPane.getSource("body");
		this.document.setSource("<xml><html>" + source + "</html></xml>");
		this.dispose();
	}

	public void setEditorToolBar(JToolBar toolbar) {
		
	}
	//20071215 shimizu wrote
	public void emphasize(String id) {
		// 20080919 hashimoto wrote
		this.textPane.emphasize(id);
//		this.textPane.getGSHTMLEditorTextPane().emphasize(id);
	}
	//20080901 hashimoto wrote
	public GSEditorTextPane getGSEditorTextPane() {
		return this.textPane;
	}
	
}
