package smart_gs.reasoning_web.logical;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.Factory;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;

public class GSFactory extends Factory {
	
	GSFactory(){
		
	}
	@Override
	public Connection createConnection(ResourcePointer source,
			ResourcePointer target, ExplanatoryNote note,int dependency) {
		return new GSConnection(source,target,note,dependency);
	}

	@Override
	public ExplanatoryNote createExplanatoryNote(String source) {
		return new GSExplanatoryNote(source);
	}

	@Override
	public ResourcePointer createResourcePointer(RWElement element) {
		return new GSResourcePointer((GS_RWElement)element);
	}

}
