/*
 * 쐬: 2006/06/21
 *
 */
package smart_gs.image_search.research.swingui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import smart_gs.image_search.logical.SearchResult;
import smart_gs.image_search.research.SearchResultSet;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.util.ImageCropper;

/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")

public class RESearchResultPanel extends JPanel{
	
	protected List<SearchResultSet> results;
	protected List<JPanel> nextResults;
	protected List<JPanel> currentResults;
	private Thread nextThread = null;
	protected final int MARGIN_WIDTH = 100;
	protected final int SIZE_TO_DISPLAY = 20;	
	protected Color grayColor;
	
	private List<JCheckBox> checkLists;
	
	private boolean isFirst = true;
	private int count = 0;
	
	public RESearchResultPanel(final List<SearchResultSet> results){
		this.results = results;	
		this.nextResults = new ArrayList<JPanel>();
		this.currentResults = new ArrayList<JPanel>();
		this.checkLists = new ArrayList<JCheckBox>();
		Color color = Color.GRAY.brighter();
		this.setLayout(new GridLayout(SIZE_TO_DISPLAY,1));
		this.grayColor = new Color(color.getRed(),color.getGreen(),color.getBlue(),128);

	}	
	
	
	public void showResult(int count){
		this.removeAll();
		if(isFirst){
			this.createResults(count);
			for(int i=0;i<this.currentResults.size();i++){
				this.add(currentResults.get(i));
			}
			isFirst = false;
			final int nextCount = count+1;
			this.nextThread = new Thread(){
				@Override
				public void run() {
					super.run();
					createResults(nextCount);
				}
			};
			this.nextThread.start();
			return;
		}
		if(nextThread.isAlive()){
			try {
				nextThread.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		for(int i=0;i<this.nextResults.size();i++){
			this.add(nextResults.get(i));
		}

		final int nextCount = count+1;
		this.nextThread = new Thread(){
			@Override
			public void run() {
				super.run();
				createResults(nextCount);
			}
		};
		this.nextThread.start();
	}
	
	public void createResults(int count){
		int beginIndex = count*SIZE_TO_DISPLAY;
		this.nextResults.clear();
		for(int i=beginIndex;i<beginIndex+SIZE_TO_DISPLAY && i < results.size();i++){
			JPanel labelPanel = new JPanel();
			JCheckBox checkBox = new JCheckBox();
			this.checkLists.add(checkBox);

			labelPanel.add(checkBox);
			
			SearchResultSet set = this.results.get(i);
			List<SearchResult> res = set.getResults();
			
			for(int j=0;j<res.size();j++){
				JPanel p = new JPanel(new FlowLayout(FlowLayout.LEFT));
				JLabel label = new JLabel();
				Spread spread = res.get(j).getSpread();
				Image image = spread.getImage();
				Rectangle2D rect = res.get(j).getRectangle();
                Image bufImage = new ImageCropper(image,rect).crop();	
				ImageIcon icon = new ImageIcon(bufImage);	
				label.setIcon(icon);
				p.add(label);
				labelPanel.add(p);
				p.setBorder(new LineBorder(Color.black));
				spread.release();
			}
			labelPanel.setBorder(new TitledBorder(res.get(0).getSpread().getURI()));
			labelPanel.addMouseListener(new LabelMouseListener(set));

			if(nextThread == null){
				this.currentResults.add(labelPanel);
			}
			else{
				this.nextResults.add(labelPanel);
			}
			
		}
	}
	
	protected class LabelMouseListener extends MouseAdapter{
		
		private SearchResultSet set;
	
		public LabelMouseListener(SearchResultSet set){
			this.set = set;
		}
		public void mouseClicked(MouseEvent e) {
			new GSEditor(set.getResults()).setVisible(true);
		}
		public void mouseEntered(MouseEvent e) {
			RESearchResultPanel.this.setCursor(new Cursor(Cursor.HAND_CURSOR));
		}
		public void mouseExited(MouseEvent e) {
			RESearchResultPanel.this.setCursor(Cursor.getDefaultCursor());
		}
	}

	public void next() {
		this.count++;
		this.showResult(count);
		
	}


	public void back() {
		this.count--;
		this.showResult(count);
		
	}
}
