package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.awt.Polygon;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PolygonParser {
	private static final String PAGE_PREFIX = "p";
	private String polyString;
	private static final String PREFIX_X = "x(\\d+)";
	private static final String PREFIX_Y = "y(\\d+)";
	public PolygonParser(String polyString) {
		this.polyString = polyString;
	}

	public List<PagedPolygon> getPolygon() throws ParseException {
        List<PagedPolygon> polyList = parse(polyString);
		return polyList;
	}

	private List<PagedPolygon> parse(String polyStr) throws ParseException {
        List<PagedPolygon> polyList = new ArrayList<PagedPolygon>();
        //        split each paged polygon string
        String[] polygons = polyStr.split(PAGE_PREFIX);
        // make each paged polygon
        for (int i = 0; i < polygons.length; i++) {
			String poly = polygons[i];
			if (poly.equals("")) {
                continue;
			}
            polyList.add(makePolygon(poly));
		}
		return polyList;
	}

	private PagedPolygon makePolygon(String poly) throws ParseException {
        int pageIndex = getPageIndex(poly);
        Pattern xPat = Pattern.compile(PREFIX_X);
        Matcher xMat = xPat.matcher(poly);
        Pattern yPat = Pattern.compile(PREFIX_Y);
        Matcher yMat = yPat.matcher(poly);

        ArrayList<String> xList = new ArrayList<String>();
        ArrayList<String> yList = new ArrayList<String>();
        int end = poly.length();
        while (xMat.find()) {
        	String x = xMat.group(1);
            xList.add(x);
            if (xMat.end() == end) {
				break;
			}
        }
        while (yMat.find()) {
			String y = yMat.group(1);
            yList.add(y);
            if (yMat.end() == end) {
				break;
			}
        }
        if (xList.size() != yList.size()) {
            throw new ParseException("mismatch x-y point num.", 0);
        }
        PagedPolygon retPoly = makePoints(pageIndex, xList, yList);
		return retPoly;
	}

	private PagedPolygon makePoints(int pageIndex, ArrayList<String> xl, ArrayList<String> yl) {
        int size = xl.size();
        Polygon polygon = new Polygon();
        for (int i = 0; i < size; i++) {
            int x = Integer.parseInt(xl.get(i));
            int y = Integer.parseInt(yl.get(i));
            polygon.addPoint(x, y);
		}
        return new PagedPolygon(pageIndex, polygon);
	}

	private int getPageIndex(String poly) {
		Pattern pat = Pattern.compile("(\\d+)x");
        Matcher mat = pat.matcher(poly);
        String page = "";
        if (mat.find()) {
            page = mat.group(1);
		}

		return Integer.parseInt(page);
	}

	/**
	 * @param args
	 * @throws ParseException
	 */
	public static void main(String[] args) throws ParseException {
		String test1 = "p5x278y13x305y14p5x34y71x86y72";
		String test2 = "p5x278y13x305y14p5x305y14x339y11";
		String test3 = "p5x278y13x305y14x339y11";

        PolygonParser parser1 = new PolygonParser(test1);
        List<PagedPolygon> polygon1 = parser1.getPolygon();

        System.out.println("test1");
        for (Iterator iterator = polygon1.iterator(); iterator.hasNext();) {
			PagedPolygon pagedPolygon = (PagedPolygon) iterator.next();
			System.out.println(pagedPolygon);
		}

        PolygonParser parser2 = new PolygonParser(test2);
        List<PagedPolygon> polygon2 = parser2.getPolygon();
        System.out.println("test2");
        for (Iterator iterator = polygon2.iterator(); iterator.hasNext();) {
			PagedPolygon pagedPolygon = (PagedPolygon) iterator.next();
			System.out.println(pagedPolygon);
        }

        PolygonParser parser3 = new PolygonParser(test3);
        List<PagedPolygon> polygon3 = parser3.getPolygon();
        System.out.println("test3");
        for (Iterator iterator = polygon3.iterator(); iterator.hasNext();) {
			PagedPolygon pagedPolygon = (PagedPolygon) iterator.next();
			System.out.println(pagedPolygon);
		}
	}

}
