package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.smleditor.swingui.GSEditorTextPane;
import sml_editor.swingui.toolbar.EditorToolBar;
import sml_editor.swingui.toolbar.EditorToolBarPlan;


@SuppressWarnings("serial")
public class GSEditorToolBar extends EditorToolBar implements ActionListener{
	public GSEditorToolBar(GSEditorTextPane textPane) {
		this(textPane,new EditorToolBarPlan());
	}
	public GSEditorToolBar(GSEditorTextPane textPane,EditorToolBarPlan toolBarPlan) {
		super(textPane,toolBarPlan);
		this.markup.removeActionListener(this.markupAction);
		this.markupAction = new GSMarkupAction();
		this.markupAction.setEditorTextPane(textPane);
		this.markup.addActionListener(this.markupAction);
		
		this.removeTag.removeActionListener(this.removeTagAction);
		this.removeTagAction = new GSRemoveTagAction();
		
		browse.addActionListener(this);
		edit.addActionListener(this);
		
		source.addActionListener(this);
		if(toolBarPlan.isSource()){
			this.add(source,0);
		}
		if(toolBarPlan.isEdit()){
			this.add(edit,0);
		}
		if(toolBarPlan.isBrowse()){
			this.add(browse,0);
		}
	}

	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(source)){
/*			this.textPane.getGSHTMLEditorTextPane().setDocumentListener(new SourceDocumentListener());
			this.textPane.getGSHTMLEditorTextPane().setMouseListener(new SourceMouseListener(this.textPane));
//			((GSEditorTextPane)this.textPane).setSourceMode(this.textPane.getGSHTMLEditorTextPane().getController().document2Source());
			//2007/10/25 kazuhiro kobayashi
			this.textPane.setCaretPosition(0); */
			onSourcemode();
		}else if(e.getSource().equals(browse)){

/*			if(((GSEditorTextPane)this.textPane).isSourceMode()){
//				try {
////					this.textPane.getGSHTMLEditorTextPane().getController().setSource(this.textPane.getGSHTMLEditorTextPane().getText());
//				} catch (SAXException e1) {
//					e1.printStackTrace();
//				}
			}
			((GSEditorTextPane)this.textPane).setIsSourceMode(false);
			this.textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSBrowseDocumentListener((GSEditorTextPane)this.textPane));
			this.textPane.getGSHTMLEditorTextPane().setMouseListener(new GSBrowseMouseListener((GSEditorTextPane)this.textPane));
			this.textPane.getGSHTMLEditorTextPane().updateText(); */
			onBrowseMode();
		}else if(e.getSource().equals(edit)){

//			if(((GSEditorTextPane)this.textPane).isSourceMode()){
////				try {
//////					this.textPane.getGSHTMLEditorTextPane().getController().setSource(this.textPane.getGSHTMLEditorTextPane().getText());
////				} catch (SAXException e1) {
////					e1.printStackTrace();
//				}
///			}

/*			((GSEditorTextPane)this.textPane).setIsSourceMode(false);
			this.textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener((GSEditorTextPane)this.textPane));
			this.textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener((GSEditorTextPane)this.textPane));
			this.textPane.getGSHTMLEditorTextPane().updateText(); */
			onEditMode();
		}
	}
	
	public void tabChanged(){
		if(edit_mode == EDIT_MODE_SOURCE){
			onSourcemode();
		}else if(edit_mode == EDIT_MODE_BROWSE){
			onBrowseMode();
		}else if(edit_mode == EDIT_MODE_EDIT){
			onEditMode();
		}
	}
		
	public void onSourcemode(){
		edit_mode = EDIT_MODE_SOURCE;
		browse.setSelected(false);
		edit.setSelected(false);
		source.setSelected(true);
		this.textPane.setMenuMode(true);
		this.textPane.setSourceMode(true);
		this.textPane.setEdit(false);
		this.textPane.updateUI();
	}
	public void onBrowseMode(){
		edit_mode = EDIT_MODE_BROWSE;

		this.textPane.setMenuMode(true);
		this.textPane.setSourceMode(false);
		this.textPane.setEdit(false);
		this.textPane.updateUI();
		browse.setSelected(true);
		edit.setSelected(false);
		source.setSelected(false);
	}
	public void onEditMode(){
		edit_mode = EDIT_MODE_EDIT;
		this.textPane.setMenuMode(false);
		this.textPane.setSourceMode(false);
		this.textPane.setEdit(true);
		this.textPane.updateUI();
		browse.setSelected(false);
		edit.setSelected(true);
		source.setSelected(false);

	}
	
}
