package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

import smart_gs.logical.Spread;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.toolbar.action.ShowSpreadAction;


@SuppressWarnings("serial")
public class SpreadTreePanel extends JPanel implements MouseListener{
	
	private SpreadTree tree;
	
	public SpreadTreePanel(){
		this.setLayout(new BorderLayout());
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.tree = SpreadTree.getInstance();
		scrollPane.addMouseListener(this);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		JPanel tree_panel = new JPanel();
		tree_panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		tree_panel.setBackground(Color.white);
		tree_panel.add(tree);
		tree_panel.setBorder(BorderFactory.createLineBorder(Color.BLACK,2));
		tree.addMouseListener(this);
		
		JPanel button_panel = new JPanel();
		JButton show = new JButton("Show");
		show.addActionListener(new ShowSpreadAction());
        button_panel.add(show);
        
        panel.add(tree_panel,BorderLayout.CENTER);

		scrollPane.setViewportView(panel);
		this.add(scrollPane,BorderLayout.CENTER);
		this.add(button_panel,BorderLayout.SOUTH);
	}
	
	public void mouseClicked(MouseEvent e) {
		if(e.getClickCount() == 2 && e.getButton() == 1){
			// I[gZ[uꎞ~
/*			boolean isAutoSave = false;
			if(WorkspaceWindow.getInstance().isTabbedPaneAvailable()){
				isAutoSave = true;
				String key = WorkspaceWindow.getInstance().tabbedPane.getURI();
				if(key != null){
					GSTabbedPaneMamager.close(key);
				}
			}*/
			Spread spread = this.tree.getSelectedSpread();
			if(spread != null){
				WorkspaceWindow.getInstance().setSpread(spread);
/*				if(isAutoSave){
					WorkspaceWindow.getInstance().autosave();
				} */
			}
			return;
		}
		//ENbNŃV[gI
		if(e.getButton() == 3){
			JPopupMenu menu = new SheetSelectPopupMenu(this.tree);
			menu.show(e.getComponent(),e.getX(),e.getY());
			
		}
		
		
	}
	
	public void mouseEntered(MouseEvent arg0) {
	}

	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent e) {
		TreePath path = this.tree.getClosestPathForLocation(e.getPoint().x,e.getPoint().y);
		this.tree.setSelectionPath(path);
		
	}

	public void mouseReleased(MouseEvent arg0) {
	}
	
}
