package smart_gs.reasoning_web.swingui.view;


import java.awt.*;
import java.awt.geom.*;
/**
 * @author kazuaki kobayashi
 *
 */
public abstract class PathView extends View {

	protected Line2D line;
	
	public PathView(){
		this.defaultColor = Color.black;
		this.currentColor = Color.black;
	}
	public abstract void drawShape(Graphics2D g);
	
	/**
	 * Linepoint邩ǂ𔻒肵܂B
	 * @param point
	 */
	public boolean contains(Point2D point){
		if(line == null){
			return false;
		}
		if (line.ptSegDist(point) < 3){
			return true;
		}else{
			return false;
		}
	}
	
	public abstract String toString();
	
	public void moveBy(Point2D d) {
		moveTo(new Point2D.Double(
					line.getX1()+d.getX(),
					line.getY1()+d.getY()),
				new Point2D.Double(
					line.getX2()+d.getX(),
					line.getY2()+d.getY())
				);	
	}

	protected void moveTo(Point2D to1,Point2D to2) {
		line.setLine(to1,to2);
	}

}
