package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.Preference;
import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.ExplanatoryNoteDialog;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygDocumentListener;
import smart_gs.smleditor.swingui.GSWysiwygMouseListener;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.util.StringUtils;
import sml_editor.swingui.toolbar.EditorToolBarPlan;

@SuppressWarnings("serial")
public class LocalViewPanel extends JPanel {
	// 2007/11/2 kazuhiro kobayshi
	private LocalViewFrame parent;
	// 2009/02/26 ADD NorthGrid
	private JTextField nameField;

	public LocalViewPanel(Hashtable<GS_RWElement, GSExplanatoryNote> elements,
			LocalViewFrame parent) {
		super();
		// 2007/11/2 kazuhiro kobayshi
		this.parent = parent;

		this.setLayout(new GridLayout(elements.size(), 1));

		Enumeration<GS_RWElement> enume = elements.keys();
		// 20080617 shimizu wrote
		Enumeration<GSExplanatoryNote> enume2 = elements.elements();

		while (enume.hasMoreElements() && enume2.hasMoreElements()) {
			GS_RWElement elem = enume.nextElement();
			// 20080617 shimizu wrote
			GSExplanatoryNote elem2 = enume2.nextElement();
			//
			// 2007/11/2 kazuhiro kobayashi
			JSplitPane splitPane = new JSplitPane();
			// JPanel panel = new JPanel(new GridLayout(1,2));
			// panel.setBorder(new TitledBorder(elem.toString()));
			//
			// 20080617 shimizu wrote;
			int a = elem2.getPosition();
			if (a == 0) {
				splitPane.setBorder(new TitledBorder("<target>"
						+ elem.toString()));
			} else {
				splitPane.setBorder(new TitledBorder("<source>"
						+ elem.toString()));
			}
			splitPane.setDividerLocation(480);

			// splitPane.resetToPreferredSizes();
			// 2007/11/20 kazuhiro kobayashi
			// panel.setPreferredSize(new Dimension(500,300));
			splitPane.setPreferredSize(new Dimension(500, 300));

			//
			//
			try {
				JPanel elementViewPanel = elem.createElementViewPanel();
				splitPane.setLeftComponent(elementViewPanel);

			} catch (NoWayToShowException e) {
				e.printStackTrace();
			}

			try {
				nameField = new JTextField(15);
				String title = elem2.getName();
				nameField.setText(title);

				// 2007/11/20 kazuhiro kobayashi
				
				// 2007/11/12 kazuhiro kobayshi
				ExplanatoryNoteDialog dialog = elements.get(elem)
						.createDialog();
				GSEditorTextPane textPane = dialog.getTextPane();
				textPane.setMarkup(true);
				parent.addTextPane(textPane,nameField);
				
				JPanel jPanel = new JPanel();
				jPanel.setLayout(new BorderLayout());
				jPanel.add(createInfoPanel(textPane,elem2),BorderLayout.NORTH);
				jPanel.add(textPane,BorderLayout.CENTER);

				JScrollPane scrollPane = new JScrollPane(jPanel);
				scrollPane.getVerticalScrollBar().setUnitIncrement(25);

				//
				splitPane.setRightComponent(scrollPane);
				// panel.add(scrollPane);
			} catch (NoWayToShowException e) {
				e.printStackTrace();
			}
			// panel.addMouseListener(new JumpAction(elem));

			splitPane.addMouseListener(new JumpAction(elem));
			// this.add(panel);
			this.add(splitPane);
		}
	}
	private JPanel createInfoPanel(GSEditorTextPane textPane,GSExplanatoryNote explanatoryNote){
		JPanel panel = new JPanel();
		panel.setLayout(new GridLayout(1,1));
		
		JPanel infoPanel = new JPanel();
		infoPanel.setLayout(new BorderLayout());
		
		JPanel datePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		Calendar calendar = Calendar.getInstance();
		String date = calendar.get(Calendar.YEAR)+"/"+calendar.get(Calendar.MONTH)+"/"+calendar.get(Calendar.DATE);
		JLabel label = new JLabel("date: "+date);
		datePanel.add(label);
		
		
		JPanel titlePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));

		nameField.setBorder(new TitledBorder("title"));
		//2007/10/23 kazuhiro kobayashi
		titlePanel.add(nameField);
		
		JTextField userField = new JTextField(15);
		String defName = Preference.getInstance().getUserName();
		userField.setText(defName);
		userField.setBorder(new TitledBorder("user name"));
		titlePanel.add(userField);
		
		
		// 2009/02/24 NorthGird
		JPanel toolbarPanel = new JPanel();;
		toolbarPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		EditorToolBarPlan toolBarPlan = new EditorToolBarPlan();
		toolbarPanel.add(new GSEditorToolBar(textPane,toolBarPlan));

	
		infoPanel.add(toolbarPanel,BorderLayout.NORTH);
		infoPanel.add(datePanel,BorderLayout.CENTER);
		infoPanel.add(titlePanel,BorderLayout.SOUTH);
		
		panel.add(infoPanel);

		return panel;
	}
	
	private class JumpAction extends MouseAdapter {
		private GS_RWElement element;

		public JumpAction(GS_RWElement element) {
			this.element = element;
		}

		@Override
		public void mouseClicked(MouseEvent e) {
			super.mouseClicked(e);
			element.show();
		}
	}
}
