/*
 * 쐬: 2006/06/02
 *
 */
package smart_gs.reasoning_web.logical;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ERCalculator;
import reasoning_web.logical.Factory;
import reasoning_web.logical.RWRepository;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.reasoning_web.desktop.swingui.DesktopWindow;
import smart_gs.reasoning_web.swingui.LocalViewFrame;

/**
 * @author kazuaki kobayashi
 * 
 */
public class GS_RWRepository extends RWRepository {

	private static GS_RWRepository singleton = new GS_RWRepository();

	private GS_RWRepository() {
		super();
	}

	public static GS_RWRepository getInstance() {
		return singleton;
	}

	@Override
	protected Factory getFactory() {
		return new GSFactory();
	}

	public Hashtable<GS_RWElement, GSExplanatoryNote> getLocalViewInfo(
			GS_RWElement element) {
		return ((GSResourcePointer) this.getResourcePointer(element))
				.getLocalViewInfo();
	}

	public void showLocalView(GS_RWElement element) {
		Hashtable<GS_RWElement, GSExplanatoryNote> info = ((GSResourcePointer) this
				.getResourcePointer(element)).getLocalViewInfo();
		new LocalViewFrame(info).setVisible(true);
	}

	public GSResourcePointer getResourcePointer(GS_RWElement element) {
		return (GSResourcePointer) super.getResourcePointer(element);
	}

	public List<RWElement> getDirectElements(RWElement element) {
		return this.getDirectElements(this.getResourcePointer(element));
	}

	public List<RWElement> getAllElements() {
		List<RWElement> elements = new ArrayList<RWElement>();
		List<ResourcePointer> pointers = this.getResourcePointers();
		for (int i = 0; i < pointers.size(); i++) {
			elements.add(pointers.get(i).getElement());
		}
		return elements;
	}

	public void restore(Element rwElement) {
		Element desktopElement = (Element) rwElement.getElementsByTagName(
				"desktop").item(0);
		DesktopWindow.getInstance().restore(desktopElement);
		Element notesElement = (Element) rwElement.getElementsByTagName(
				"expNotes").item(0);
		ExpNoteManager.getInstance().restore(notesElement);

		NodeList list = rwElement.getElementsByTagName("connection");
		for (int i = 0; i < list.getLength(); i++) {
			Element element = (Element) list.item(i);
			GSConnection connection = GSConnection.restore(element);
			this.register(connection.getSourcePointer());
			this.register(connection.getTargetPointer());
			this.addConnection(connection);
		}
		new ERCalculator().calculate();
	}

	public void save(Document document, Element parent) {
		Element element = document.createElement("reasoning_web");
		ExpNoteManager.getInstance().save(document, element);
		DesktopWindow.getInstance().save(document, element);
		for (int i = 0; i < this.connections.size(); i++) {
			GSConnection connection = (GSConnection) this.connections.get(i);
			Element elem = connection.createXMLElement(document);
			element.appendChild(elem);
		}
		parent.appendChild(element);

	}

	// 2007/11/1 kazuhiro kobayashi
	public void removeConnection(Connection connection) {
		if (connection != null) {
			//2007/11/19 kazuhiro kobayashi
			this.connections.remove(connection);
			connection.getSourcePointer().removeConnection(connection);
			connection.getTargetPointer().removeConnection(connection);
			if (!connection.getSourcePointer().hasConnection()) {
				this.pointers.remove(connection.getSourcePointer());
			}
			if (!connection.getTargetPointer().hasConnection()) {
				this.pointers.remove(connection.getTargetPointer());
			}
			//
		}
	}

	public void removePointer(ResourcePointer pointer) {
		if (pointer != null) {
			this.pointers.remove(pointer);

		}
	}
}
