package jp.ac.hokudai.meme.core_smart_gs.searcher;

import java.awt.Polygon;

public class PagedPolygon {
	private final Polygon polygon;
	private final int pageNum;

	public PagedPolygon(int pageNum, Polygon polygon) {
		this.pageNum = pageNum;
		this.polygon = polygon;
	}

	public Polygon getPolygon() {
		return polygon;
	}

	public int getPageNum() {
		return pageNum;
	}

	@Override
	public String toString() {
		StringBuffer ps = new StringBuffer();
		int pNum = polygon.npoints;
		int[] xs = polygon.xpoints;
		int[] ys = polygon.ypoints;
		for (int i = 0; i < pNum; i++) {
            int x = xs[i];
            int y = ys[i];
            ps.append("[" + x + ", " + y +"]");
		}
        String ret = "page: " + pageNum + " poly: " + ps.toString();
        return ret;
	}

}
