package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.FreeLineMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.drawing_mode.EraserMode;

import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.Region;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.drawing_tool.ImageLabel;

@SuppressWarnings("serial")
public class ImageToolBar extends JToolBar implements ActionListener{
	
	private JButton select;
	private JButton eraser;
	private JButton rectangle;
	private JButton marker;
	private JButton lasso;
	private JButton zoomIn;
	private JButton zoomOut;
	
//	private JButton hideRegion;
	private JButton showRegion;
	
//	private JButton changeSheet;
	
	private AbstractGSWindow parent;
	
	public ImageToolBar(AbstractGSWindow parent){
		this.parent = parent;
		
		this.select = new JButton(new ImageIcon(GSConstants.ICON_PATH+"select.gif"));
		this.select.addActionListener(this);
		this.add(this.select);
		
		this.eraser = new JButton(new ImageIcon(GSConstants.ICON_PATH+"delete.gif"));
		this.eraser.addActionListener(this);
		this.add(this.eraser);
		
		this.rectangle = new JButton("Rectangle");
		this.rectangle.addActionListener(this);
		this.add(this.rectangle);
		
		this.marker = new JButton("Marker");
		this.marker.addActionListener(this);
		this.add(this.marker);
		
		this.lasso = new JButton("Lasso");
		this.lasso.addActionListener(this);
		this.add(this.lasso);
		
		this.zoomIn = new JButton(new ImageIcon(GSConstants.ICON_PATH+"zoom_in.gif"));
		this.zoomIn.addActionListener(this);
		this.add(this.zoomIn);
		
		this.zoomOut = new JButton(new ImageIcon(GSConstants.ICON_PATH+"zoom_out.gif"));
		this.zoomOut.addActionListener(this);
		this.add(this.zoomOut);
		/*
		 * 2007/9/11
		 */
//		this.hideRegion = new JButton("hideRegion");
//		this.hideRegion.addActionListener(this);
//		this.add(this.hideRegion);
		
		this.showRegion = new JButton("Show Region");
		this.showRegion.addActionListener(this);
		this.add(this.showRegion);
//		
//		this.changeSheet = new JButton("Sheet");
//		this.changeSheet.addActionListener(this);
//		this.add(this.changeSheet);
	}

	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(this.select)){
			DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
		}else if(e.getSource().equals(this.rectangle)){
			DefaultState.getInstance().setMode(RectangleMode.getInstance());
		}else if(e.getSource().equals(this.marker)){
			DefaultState.getInstance().setMode(MarkerMode.getInstance());
		}else if(e.getSource().equals(this.lasso)){
			DefaultState.getInstance().setMode(FreeLineMode.getInstance());
		}else if(e.getSource().equals(this.zoomIn)){
			parent.getSpreadCanvas().zoomIn();
		}else if(e.getSource().equals(this.zoomOut)){
			parent.getSpreadCanvas().zoomOut();
		}else if(e.getSource().equals(this.eraser)){
			Region region = UniSelectedState.getInstance().getSelectedRegion();
			new DeleteRegionAction(region).execute();
//			DefaultState.getInstance().setMode(EraserMode.getInstance());
			
			parent.repaint();
			
//		}else if(e.getSource().equals(this.hideRegion)){			
//			parent.getSpreadCanvas().getSpread().showProtectedRegions();
//			parent.repaint();
		}else if(e.getSource().equals(this.showRegion)){
			parent.getSpreadCanvas().getSpread().changeShowRegion();
			parent.repaint();
		}
//		else if(e.getSource().equals(this.changeSheet)){
//			parent.getSpreadCanvas().getSpread().roundSheet();
//			parent.repaint();
//		}
	}
	
}
